% Plot mean and standard deviation

function plot_std(s,x,c)

x(find(x > 1)) = 1; % truncate large errors

mx = mean(x,2); sx = std(x,[],2);
plot(s,mx,c,'linewidth',2), hold on
[max_mx,i] = max(mx);
axis([s(1) s(end)+eps 0 max_mx+sx(i)])

m = length(mx);
for i = 1:m
   plot([s(i) s(i)], [mx(i)-sx(i) mx(i)+sx(i)],c,'linewidth',2)
end

hold off
xlabel('x'), ylabel('y'), title('t')
set(gca,'fontsize',20)
