% Test factorize (Figure 1)
clear all, close all
rand('state',0), randn('state',0) 

% true data
m = 10; l = 1; n = l*5; k = 2; 
s = 0.01; 

% true data
c0 = [eye(k); randn(m-k,k)]; 
% introduce zeros at random in each row of the (2,2) block
for i = k+1:m
    Z = randperm(k);
    nz = min(round(rand * k),k-1);
    c0(i,Z(1:nz)) = 0;
end
[I,J]  = find(c0(k+1:end,:) == 0); I = I + k;

p0 = kron(ones(1,l),rand(k,n/l));
x0 = c0*p0;
v  = rand(m,n); % standard deviations 
w  = 1./v;      % weight matrix

% noisy data
e = v .* randn(m,n);
x = x0 + s * e / norm(e,'fro') * norm(x0,'fro'); 

% apply the algorithm
opt.tol_c = 1e-16;
opt.tol_p = 1e-16;
opt.disp    = 'off'; 
opt.maxiter = 1000; 

% using prior knowledge
[ch,ph,info] = factorize(x,k,w,opt,1,l,[I(1:end-1),J(1:end-1)]); xh = ch * ph; info
e_ph = norm(p0-ph,'fro')/norm(p0,'fro');
e_ch = norm(c0-ch,'fro')/norm(c0,'fro');
e_xh = norm(x0-xh,'fro')/norm(x0,'fro');
fh   = norm(w.*(x - ch*ph),'fro');

% without prior knowledge
opt.maxiter = 100; 
[ch2,ph2,info2] = factorize(x,k,ones(m,n),opt); xh2 = ch2 * ph2; info2;
e_ph2 = norm(p0-ph2,'fro')/norm(p0,'fro');
e_ch2 = norm(c0-ch2,'fro')/norm(c0,'fro');
e_xh2 = norm(x0-xh2,'fro')/norm(x0,'fro');

res = num2cell([e_xh2 e_ph2 e_ch2 ch2(I(end),J(end)); e_xh e_ph e_ch ch(I(end),J(end))]);
{
    '' 'err x' 'err p' 'err c' 'should be zero';
    'no prior' res{1,:};
    'prior'    res{2,:};
}

opt.maxiter = 100; 
[ch,ph,info,conv] = factorize(x,k,w,opt,1,l,[I(1:end-1),J(1:end-1)],[],ch,ph,fh);

% Plot the convergence 

figure
plot(conv(:,1)/max(conv(:,1)),'o'), hold on, plot(conv(:,2)/max(conv(:,2)),'r.')
xlabel('x'), ylabel('y'), title('t')
set(gca,'fontsize',20)
legend('in w-norm','in f-norm')
%print -depsc factorize_conv1

figure
plot(conv(:,3)/max(conv(:,3)),'o'), hold on, plot(conv(:,4)/max(conv(:,4)),'r.')
xlabel('x'), ylabel('y'), title('t')
set(gca,'fontsize',20)
legend('in w-norm','in f-norm')
%print -depsc factorize_conv2

figure
plot(conv(:,5)/max(conv(:,5)),'o'), hold on, plot(conv(:,6)/max(conv(:,6)),'r.')
xlabel('x'), ylabel('y'), title('t')
set(gca,'fontsize',20)
legend('in w-norm','in f-norm')
%print -depsc factorize_conv3

return

figure
plot(conv(:,7)/max(conv(:,7)),'o'),
xlabel('x'), ylabel('y'), title('t')
set(gca,'fontsize',20)
%print -depsc factorize_conv4
