% Simulation examples for the paper (Figures 3-7)
clear all, close all
rand('state',0), randn('state',0) 

% true data
m = 100; n = 6; k = 2; 
N = 10; % # of Monte Carlo simulations
np = 10; % # of points for the plots

test = 1
switch test
   case 1, w = rand(m,n); l = 1; zeros_in_c = 0; nonneg = 0;
   case 2, w = ones(m,n); l = 3; zeros_in_c = 0; nonneg = 0;
   case 3, w = ones(m,n); l = 1; zeros_in_c = 1; nonneg = 0;
   case 4, w = ones(m,n); l = 1; zeros_in_c = 0; nonneg = 1;
   case 5, w = rand(m,n); l = 3; zeros_in_c = 1; nonneg = 1;
end

% true data
c0 = [eye(k); randn(m-k,k)];
if zeros_in_c
   % introduce zeros at random in each row of the (2,2) block
   for i = k+1:m-1
      Z = randperm(k);
      nz = min(round(rand * k),k-1);
      c0(i,Z(1:nz)) = 0;
   end
end
[I,J]  = find(c0(k+1:end,:) == 0); I = I + k;
c0(end) = 0; % test zero

if nonneg
   p0 = kron(ones(1,l),rand(k,n/l));
else
   p0 = kron(ones(1,l),randn(k,n/l));
end
x0 = c0*p0;

opt.tol_c = 1e-4;
opt.tol_p = 1e-4;
opt.disp    = 'off'; 
opt.maxiter = 100; 

s = linspace(0,0.2,np);
for i = 1:np 
fprintf('%d: ',i)
   for j = 1:N

fprintf('%d, ',j)

% noisy data
e = w .* randn(m,n);
x = x0 + s(i) * e / norm(e,'fro') * norm(x0,'fro'); 

% apply the algorithm

% using prior knowledge
[ch,ph,info] = factorize(x,k,1./w,opt,nonneg,l,[I,J]); xh = ch * ph;
e_ph(i,j) = norm(p0-ph,'fro')/norm(p0,'fro');
e_ch(i,j) = norm(c0-ch,'fro')/norm(c0,'fro');
e_xh(i,j) = norm(x0-xh,'fro')/norm(x0,'fro');
zh(i,j) = abs(ch(end));

% without prior knowledge
[ch2,ph2,info2] = factorize(x,k,ones(m,n),opt); xh2 = ch2 * ph2;
e_ph2(i,j) = norm(p0-ph2,'fro')/norm(p0,'fro');
e_ch2(i,j) = norm(c0-ch2,'fro')/norm(c0,'fro');
e_xh2(i,j) = norm(x0-xh2,'fro')/norm(x0,'fro');
zh2(i,j) = abs(ch2(end));

   end
fprintf('\n')
end

figure
plot_std(s,e_xh,'b-'), hold on
plot_std(s,e_xh2,'r--')
%eval(['print -depsc factorize_test' int2str(test) '_f1.eps'])

figure
plot_std(s,e_ph,'b-'), hold on
plot_std(s,e_ph2,'r--')
%eval(['print -depsc factorize_test' int2str(test) '_f2.eps'])

figure
plot_std(s,e_ch,'b-'), hold on
plot_std(s,e_ch2,'r--')
%eval(['print -depsc factorize_test' int2str(test) '_f3.eps'])

figure
plot_std(s,zh,'b-'), hold on
plot_std(s,zh2,'r--')
%eval(['print -depsc factorize_test' int2str(test) '_f4.eps'])

