% Test rank estimation by factorize (Figure 2)
clear all, close all
rand('state',0), randn('state',0) 

% true data
m = 200; l = 2; n = l*5; r0 = 5; 
s = 0.2; 

% true data
c0 = [eye(r0); randn(m-r0,r0)]; 
% introduce zeros at random in each row of the (2,2) block
for i = r0+1:m
    Z = randperm(r0);
    nz = min(round(rand * r0),r0-1);
    c0(i,Z(1:nz)) = 0;
end
[I,J]  = find(c0(r0+1:end,:) == 0); I = I + r0;

p0 = kron(ones(1,l),rand(r0,n/l));
x0 = c0*p0;
v  = rand(m,n); % standard deviations up to a scaling factor
w = 1 ./ v;     % weights

% noisy data
e = v .* randn(m,n);
x = x0 + s * e / norm(e,'fro') * norm(x0,'fro'); 

% apply the algorithm
opt.tol_c = 1e-4;
opt.tol_p = 1e-4;
opt.disp    = 'off'; 
opt.maxiter = 100; 

for r = 1:9
    % using prior knowledge
    [ch,ph,info] = factorize(x,r,w,opt,0,l); xh = ch * ph;
    e_xh(r) = norm(1./w .* (x-xh),'fro');
    
    % without prior knowledge
    [ch2,ph2,info2] = factorize(x,r,ones(m,n),opt); xh2 = ch2 * ph2;
    e_xh2(r) = norm(x-xh2,'fro')/norm(x0,'fro');
end

plot(e_xh/max(e_xh),'sb','markersize',7,'linewidth',2), hold on
plot(e_xh2/max(e_xh2),'or','markersize',7,'linewidth',2)
xlabel('x'), ylabel('y'), title('t')
set(gca,'fontsize',20)
ax = axis; axis([1 9 0 ax(4)])
legend('LRA','constrained LRA')
%print -depsc factorize_test6_f1.eps

