addpath ~/mfiles/matrix-completion/
addpath ~/mfiles/matrix-completion/PROPACK_simple
addpath ml-data

m = 2; % rank 
q = 943; N = 1682;
lb = 1; ub = 5;

for i = 1:5; 
    fprintf('\nTest set %d:\n\n',i)
    
    % Load identification data
    eval(['u = load(''u' int2str(i) '.base'');'])
    d  = sparse(u(:,1),u(:,2),u(:,3),q,N); 
    ne = size(u,1); % number of given elements
    s  = (d ~= 0);  % weight matrix for wlra
    tmp = s.*(d); nd(i) = norm(tmp(:),1) / length(tmp(:)); 
    
    % Initial approximation
    di = full(d);
    di(find(d == 0)) = (lb+ub)/2; % set missing elements to the median
    tic, [opt.P,l0] = lra(di,m); t0(i) = toc; clear di
    dh0 = quantize(opt.P * l0,lb,ub);
    tmp = s.*(d - dh0); err0(i) = norm(tmp(:),1) / length(tmp(:)); 

    % Apply WLRA
    opt.Display = 'iter'; opt.MaxIter = 40; 
    [ph1,lh1,info1(i)] = wlra(d,m,s,opt); 
    err1(i) = info1(i).err;
    t1(i) = info1(i).time;
    dh1 = quantize(ph1 * lh1,lb,ub);
    tmp = s.*(d - dh1); err1(i) = norm(tmp(:),1) / length(tmp(:)); 

    % Apply SVT
    tau = 5*sqrt(q*N); delta = 1.2/(ne/q/N); % SVT calling parameters
    Ie = u(:,1) + q * (u(:,2)-1);
    try
        tic, [U,S,V] = SVT([q N],Ie,u(:,3),tau,delta); t4(i) = toc;
        dh4  = quantize(U(:,1:m)*S(1:m,1:m)*V(:,1:m)',lb,ub);
    catch
        dh4 = NaN; t4 = NaN; % SVT not installed
    end
    tmp = s.*(d - dh4); err4(i) = norm(tmp(:),1) / length(tmp(:)); 

    % Load validatation data and compute prediction errors
    eval(['u = load(''u' int2str(i) '.test'');'])
    dval  = sparse(u(:,1),u(:,2),u(:,3),q,N); 
    neval = size(u,1); % number of given elements
    sval  = (dval ~= 0);  % weight matrix for wlra
    tmp = sval.*(dval); ndval(i) = norm(tmp(:),1) / length(tmp(:)); 
    
    tmp = sval.*(dval - dh0); e0(i) = norm(tmp(:),1) / length(tmp(:));
    tmp = sval.*(dval - dh1); e1(i) = norm(tmp(:),1) / length(tmp(:));
    tmp = sval.*(dval - dh4); e4(i) = norm(tmp(:),1) / length(tmp(:));
end

format long
res = [mean(err0)  mean(err1)  mean(err4);
       mean(e0) mean(e1) mean(e4);
       mean(t0)        mean(t1)        mean(t4)]
