randn('state',0); rand('state',0);   
p0 = rand(q,m); l0 = rand(m,N);    % true data matrix
ne  = round((1-r)*q*N);  % number of given elements
ner = round(ne/q);       % number of given elements per row 
I = []; J = [];          % row/column indeces of the given elements
for i = 1:q
  I = [I i*ones(1,ner)]; % all selecteded elements are in the ith row
  rp = randperm(N);
  J = [J rp(1:ner)];     % and have random column indexes
end
ne = length(I);
% Find indexes of columns with less than M given elements
tmp = (1:N)'; 
J_del = find(sum(J(ones(N,1),:) == tmp(:,ones(1,ne)),2) < m);
% Remove them
l0(:,J_del) = []; 
% Redefine I and J
tmp = sparse(I,J,ones(ne,1),q,N); tmp(:,J_del) = [];
[I,J] = find(tmp); N = size(l0,2); 
d0 = p0 * l0;       % full true data matrix
Ie = I + q * (J-1); % indexes of the given elements from d0(:)
d  = zeros(q*N,1);  d(Ie) = d0(Ie) + sigma*randn(size(d0(Ie))); 
d  = reshape(d,q,N);
s  = zeros(q,N); s(Ie) = 1;
tic, [p0,l0] = lra(d,m); t0 = toc; 
err0 = norm(s.*(d - p0*l0),'fro')^2; e0 = norm(d0 - p0*l0,'fro')^2;
[ph1,lh1,info1] = wlra(d,m,s);     e1 = norm(d0 - ph1*lh1,'fro')^2;
opt.Method = 'vp'; opt.Algorithm = 'fminunc'; 
[ph2,lh2,info2] = wlra(d,m,s,opt); e2 = norm(d0 - ph2*lh2,'fro')^2;
opt.Method = 'vp'; opt.Algorithm = 'lsqnonlin'; 
[ph3,lh3,info3] = wlra(d,m,s,opt); e3 = norm(d0 - ph3*lh3,'fro')^2;
tau = 5*sqrt(q*N); delta = 1.2/(ne/q/N); % SVT calling parameters
try
    tic, [U,S,V] = SVT([q N],Ie,d(Ie),tau,delta); t4 = toc;
    dh4  = U(:,1:m)*S(1:m,1:m)*V(:,1:m)'; % approximation
catch
    dh4 = NaN; t4 = NaN; % SVT not installed
end
err4 = norm(s.*(d - dh4),'fro')^2; e4 = norm(d0 - dh4,'fro')^2;
nd = norm(s.*d,'fro')^2; nd0 = norm(d0,'fro')^2; 
format long
res = [err0/nd info1.err/nd  info2.err/nd  info3.err/nd err4/nd;
       e0/nd0  e1/nd0        e2/nd0        e3/nd0       e4/nd0;
       t0      info1.time    info2.time    info3.time   t4]
