/* These tools are Free Software, licensed under the MIT license. *
 *  Copyright 2007, Philip Boulain. See LICENSE.TXT for details.  */
#include <string.h>
#include "mediawikiformat.h"

bool initFilter(int argc, char** argv) { return (argc == 0); }

void killFilter(void) {}

bool generatesXMLOutput(void) { return true; }

bool processPage(const mw_page* page) {
	// Does the page title contain a colon?
	if(strchr((const char*) page->title.chars, ':')) {
		// Ignore it
		return false;
	} else {
		// Ok, this is an article
		writePage(page);
		return true;
	}
}

void processRevision(const mw_page* page, const mw_revision* revision) {
	// Keep all revisions of any page kept
	writeRevision(revision);
}

