/* These tools are Free Software, licensed under the MIT license. *
 *  Copyright 2007, Philip Boulain. See LICENSE.TXT for details.  */
#include <stdio.h>
#include "mediawikiformat.h"

bool initFilter(int argc, char** argv) { return (argc == 0); }

void killFilter(void) {}

bool generatesXMLOutput(void) { return false; }

bool processPage(const mw_page* page) {
	// Display the title
	puts("");
	puts((const char*) page->title.chars);
	// Always process revisions
	return true;
}

void processRevision(const mw_page* page, const mw_revision* revision) {
	printf("%s(%s)",
		revision->contributor.registered ? "r" : "u",
		(const char*) revision->contributor.id.chars);
	if(revision->minor) { puts(" (minor edit)"); } else { puts(""); }
	printf("  %zd bytes of text starting \"%.60s...\"\n", revision->text.len,
		(const char*) revision->text.chars);
}

