# vim: syntax=gnuplot
set terminal latex
set output "editsmags.ptex"
set size 5/5, 3/3
set logscale y 10
set format y "$10^{%L}$"
unset title
set xlabel 'Edit magnitude, $\pm$50'
set ylabel 'Number\\of edits'
plot [50:7050] \
	'../wikipedia-study/ag-p1pl-editmagsall.dat'   using 1:2 title    'All users' with lines lt 5, \
	'../wikipedia-study/ag-p1pl-editmagsreg.dat'   using 1:2 title   'Registered' with lines lt 1, \
	'../wikipedia-study/ag-p1pl-editmagsunreg.dat' using 1:2 title 'Unregistered' with lines lt 4, \
	'../wikipedia-study/ag-p1p-editmagsall.dat'    using 1:2 title 'All, approx.' with lines lt 18

#	'../wikipedia-study/ag-p4p-editmagsall.dat'    using 1:2 title 'All, 0.04\%' with lines lt 3

