# vim: syntax=gnuplot
set terminal latex # eepic present, but pdflatex doesn't like the specials
set output "editsusersall.ptex" # ptex for 'plotted TeX'
set size 5/5, 3/3
set logscale y 10
set format y "$10^{%L}$"
set logscale x 10
set format x "$10^{%L}$"
unset title
set xlabel 'Edit count, $\pm$5'
set ylabel 'Number\\of users'
plot [5:2000] \
	'../wikipedia-study/ag-p4p-editsusersall.dat'   using 1:2 title    'All users' with lines lt 5, \
	'../wikipedia-study/ag-p4p-editsusersreg.dat'   using 1:2 title   'Registered' with lines lt 1, \
	'../wikipedia-study/ag-p4p-editsusersunreg.dat' using 1:2 title 'Unregistered' with lines lt 4

