# vim: syntax=gnuplot
set terminal latex
set output "editsuserscats.ptex"
set size 5/5, 3/3
set logscale y 10
set format y "$10^{%L}$"
set format x "$%g$"
unset title
set xlabel 'Edit count, $\pm$5'
set ylabel 'Number\\of users'
# set pointsize 0.25 # No effect :/
plot [5:95] \
	'../wikipedia-study/ag-p4p-editsuserscatmajor.dat'  using 1:2 title 'Content'   with linespoints lt 3 pt 0, \
	'../wikipedia-study/ag-p4p-editsuserscatplinks.dat' using 1:2 title 'Page link' with linespoints lt 1 pt 4, \
	'../wikipedia-study/ag-p4p-editsuserscatulinks.dat' using 1:2 title 'URL link'  with linespoints lt 1 pt 2, \
	'../wikipedia-study/ag-p4p-editsuserscattempl.dat'  using 1:2 title 'Template'  with linespoints lt 1 pt 5, \
	'../wikipedia-study/ag-p4p-editsuserscatcateg.dat'  using 1:2 title 'Category'  with linespoints lt 1 pt 1, \
	'../wikipedia-study/ag-p4p-editsuserscatrevert.dat' using 1:2 title 'Revert'    with linespoints lt 4 pt 0, \
	'../wikipedia-study/ag-p4p-editsuserscatlistof.dat' using 1:2 title 'List of'   with linespoints lt 1 pt 3
# pt 7 would be better, but circles not working :/

# Not useful---all zero:
#	'../wikipedia-study/ag-p4p-editsuserscatabuse.dat'  using 1:2 title 'Abuse'     with linespoints lt 1, \

