/* These tools are Free Software, licensed under the MIT license. *
 *  Copyright 2007, Philip Boulain. See LICENSE.TXT for details.  */
#ifndef MEDIAWIKIFORMAT_H
#define MEDIAWIKIFORMAT_H

#include <stdbool.h>
#include "upstr.h"

typedef struct {
	upstr title;
} mw_page;

typedef struct {
	bool registered;
	upstr id; // If registered, the numeric ID, as a string to avoid
	          // unnecessary parsing overhead (quicker to strcmp).
		  // Else what the XML calls 'ip', which is really some
		  // arbitrary string, _usually_ a hostname or IP.
} mw_user;

typedef struct {
	mw_user contributor;
	bool minor;
	upstr text;
} mw_revision;

////////  Implement these as part of the specific filter  ////////

// Perform any required initialisation.
// argc and argv refer to any EXTRA arguments, so the count may well be zero.
// Return true if initialisation successful, false to exit.
bool initFilter(int argc, char** argv);

// Return true if this filter generates XML output.
// Needed to know that a (mostly empty) XML file should be generated even if
// writePage() is never called, and for command line validation.
bool generatesXMLOutput(void);

// Handle an upcoming page. The ordering of the Wikipedia XML dump is taken to
// be significant, hence this is is called BEFORE the revisions, giving a chance
// to avoid processing them if the page is evidently useless.
// Return true to continue parsing this page; return false to skip
bool processPage(const mw_page* page);

// Handle a revision. The containing page data is provided again for
// convenience.
void processRevision(const mw_page* page, const mw_revision* revision);

// Filter shutdown. This is called once processing has finished. It is NOT
// called if initFilter() returned false. It is still safe to write pages and
// revisions at this stage.
void killFilter(void);

////////  Use these to write output document, if required  ////////

// Write an upcoming page. Pages are automatically closed by either subsequent
// pages, or the end of processing. A page must be started before revisions are
// written. generatesXMLOutput() _MUST_ have returned true.
void writePage(const mw_page* page);

// Write a revision. generatesXMLOutput() _MUST_ have returned true.
void writeRevision(const mw_revision* revision);

#endif

