/* These tools are Free Software, licensed under the MIT license. *
 *  Copyright 2007, Philip Boulain. See LICENSE.TXT for details.  */
#ifndef MEDIAWIKIMARKUP_H
#define MEDIAWIKIMARKUP_H

#include "upstr.h"
#include "bag.h"

// Outgoing links discovered are built into a null-terminated array of upstrs,
// written to the links argument, if it is provided (also caller-owned).
typedef struct {
	// These are bags of heap-allocated, NULL-terminated, char* strings
	// Templates which have been used, /including/ arguments after the pipe,
	// and a preceeding subst: if used.
	MD_Bag* templates;
	// Categories under which this page has been placed
	MD_Bag* categories;
	// Outgoing links to other pages, possibly via interwiki
	MD_Bag* pagelinks;
	// Outgoing links to arbitrary URLs
	MD_Bag* urllinks;
} mw_markupinfo;

// Initialise a mw_markupinfo structure; use this before passing it to
// mw_stripMarkupRoughly(). Returns false if there wasn't enough memory.
bool mw_markupinfo_init(mw_markupinfo* info);

// Empty a mw_markupinfo. Used automatically to trample them while re-using the
// heap allocations.
void mw_markupinfo_clean(mw_markupinfo* info);

// Destroy the memory allocated by initialising a mw_markupinfo.
void mw_markupinfo_destroy(mw_markupinfo* info);

// Processes the provided wikitext into rough plaintext and some markup
// information. Tramples 'plaintext' with the plaintext, and 'info' with
// information about the markup removed. These cannot be NULL.
// This is not a precise text/plain converter! The MediaWiki format is simply
// too horrendous to parse with anything but the MediaWiki source code.
void mw_stripMarkupRoughly(const upstr* restrict wikitext, upstr* restrict plaintext, mw_markupinfo* info);

// STRANGE AND UNUSUAL UTILITY METHODS
// Compare bags of strings. Returns true if both bags contain strings which are
// equal, even if they are not at the same address.
bool mw_bagofstrings_eq(const MD_Bag* one, const MD_Bag* two);

#endif

