/* These tools are Free Software, licensed under the MIT license. *
 *  Copyright 2007, Philip Boulain. See LICENSE.TXT for details.  */

#define _BSD_SOURCE /* random(), please, Linux. */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "mediawikiformat.h"

// random(), not rand(). Not RAND_MAX; no replacement found.
// This value comes from the manpage, and is thus assumed standard.
#define RANDOM_MAX ((long) 2147483647)

long rand_thresh;

bool initFilter(int argc, char** argv) {
	double thresh = 0.5;
	if(argc > 1) { return false; }
	if(argc) {
		char* end;
		thresh = strtod(argv[0], &end);
		if(*(argv[0]) == '\0' || *end != '\0') { // see strtod manpage: !"entire string valid"
			fprintf(stderr, "'%s' isn't a number; should be probability of keeping node.\n", argv[0]);
			return false;
		}
		if(thresh < 0 || thresh > 1) { // Allow no or all nodes if they really want
			fprintf(stderr, "%lf doesn't make sense as a probability of keeping node (expect 0--1).\n", thresh);
			return false;
		}
	}
	rand_thresh = thresh * RANDOM_MAX;
	//fprintf(stderr, "Threshold is %lf, so expect number less than %ld (out of %ld).\n", thresh, rand_thresh, RANDOM_MAX);
	srandom(time(0));
	return true;
}

void killFilter(void) {}

bool generatesXMLOutput(void) { return true; }

bool processPage(const mw_page* page) {
	if(random() < rand_thresh) {
		writePage(page);
		return true;
	} else { return false; }
}

void processRevision(const mw_page* page, const mw_revision* revision) {
	writeRevision(revision);
}

