/*
 * Decompiled with CFR 0.152.
 */
package ThematicModelProto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Natom
implements Comparable<Natom> {
    String id;
    public String url;
    public String author;
    public HashSet<String> features = new HashSet();
    public Double thematicScore = null;
    public Double componentScore = null;
    public Double score = null;
    public HashMap<String, double[]> motifsmatch = new HashMap();
    public HashMap<String, double[]> themesmatch = new HashMap();
    public HashMap<String, double[]> componentsmatch = new HashMap();

    public Natom(String id, String url, HashSet<String> features) {
        this(id, url, features, "");
    }

    public Natom(String id, String url, HashSet<String> features, String author) {
        this.id = id;
        this.url = url;
        this.features = features;
        this.author = author;
    }

    public HashSet<String> getFeatures() {
        return this.features;
    }

    public String getURL() {
        return this.url;
    }

    public Element toXML(Document doc) {
        Element natom = doc.createElement("natom");
        Element idEl = doc.createElement("id");
        idEl.appendChild(doc.createTextNode(this.id));
        natom.appendChild(idEl);
        Element urlEl = doc.createElement("url");
        urlEl.appendChild(doc.createTextNode(this.url));
        natom.appendChild(urlEl);
        Element authorEl = doc.createElement("author");
        authorEl.appendChild(doc.createTextNode(this.author));
        natom.appendChild(authorEl);
        Element tagsEl = doc.createElement("tags");
        natom.appendChild(tagsEl);
        Iterator<String> iterator = this.features.iterator();
        while (iterator.hasNext()) {
            String feature;
            String tagS = feature = iterator.next();
            Element tag = doc.createElement("tag");
            tag.appendChild(doc.createTextNode(tagS));
            tagsEl.appendChild(tag);
        }
        Element metricsEl = doc.createElement("metrics");
        if (this.componentScore != null) {
            Element componentCoverage = doc.createElement("componentCoverage");
            componentCoverage.appendChild(doc.createTextNode(this.componentScore.toString()));
            metricsEl.appendChild(componentCoverage);
        }
        if (this.thematicScore != null) {
            Element thematicCoverage = doc.createElement("thematicCoverage");
            thematicCoverage.appendChild(doc.createTextNode(this.thematicScore.toString()));
            metricsEl.appendChild(thematicCoverage);
        }
        if (this.score != null) {
            Element averageCoverage = doc.createElement("averageCoverage");
            averageCoverage.appendChild(doc.createTextNode(this.score.toString()));
            metricsEl.appendChild(averageCoverage);
        }
        if (metricsEl.hasChildNodes()) {
            natom.appendChild(metricsEl);
        }
        return natom;
    }

    @Override
    public int compareTo(Natom otherNatom) {
        return (int)(otherNatom.score - this.score);
    }
}

