/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos;

public class PhotoPlace {
    public static final int SET = 1;
    public static final int POOL = 2;
    private String id;
    private int kind;
    private String title;

    public PhotoPlace(int kind, String id, String title) {
        this.setKind(kind);
        this.id = id;
        this.title = title;
    }

    public PhotoPlace(String kind, String id, String title) {
        this.setKind(kind);
        this.id = id;
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public int getKind() {
        return this.kind;
    }

    protected void setKind(int kind) {
        this.kind = kind;
    }

    protected void setKind(String kindStr) {
        if ("pool".equalsIgnoreCase(kindStr)) {
            this.setKind(2);
        } else if ("set".equalsIgnoreCase(kindStr)) {
            this.setKind(1);
        } else {
            throw new IllegalArgumentException("Invalid kind [" + kindStr + "]");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getKindAsString() {
        String s;
        switch (this.kind) {
            case 1: {
                s = "set";
                break;
            }
            case 2: {
                s = "pool";
                break;
            }
            default: {
                s = "unknown(" + this.kind + ")";
            }
        }
        return s;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PhotoPlace)) {
            return false;
        }
        PhotoPlace other = (PhotoPlace)obj;
        if (other.kind != this.kind) {
            return false;
        }
        if (this.id != null ? !this.id.equals(other.id) : other.id != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(other.title) : other.title != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getKindAsString() + " id=\"" + this.id + "\" title=\"" + this.title + "\"]";
    }
}

