/*
 * Decompiled with CFR 0.152.
 */
package ThematicModelProto;

import ThematicModelProto.Helpers;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Motif {
    private HashSet<String> features = new HashSet();
    private String name;

    public Motif(String name, String file) {
        String fileName = String.valueOf(file) + name.toLowerCase().replace(" ", "") + ".te";
        this.parseDocument(fileName);
    }

    private void parseDocument(String file) {
        Document dom = Helpers.parseXmlFile(file);
        Element docEle = dom.getDocumentElement();
        this.name = docEle.getAttribute("name");
        NodeList nl = docEle.getElementsByTagName("feature");
        if (nl == null) {
            return;
        }
        int i = 0;
        while (i < nl.getLength()) {
            Node el = nl.item(i);
            this.features.add(el.getFirstChild().getNodeValue());
            ++i;
        }
    }

    public HashSet<String> getFeatures() {
        return this.features;
    }

    public String getName() {
        return this.name;
    }
}

