/*
 * Decompiled with CFR 0.152.
 */
package ThematicModelProto;

import ThematicModelProto.Helpers;
import ThematicModelProto.Motif;
import ThematicModelProto.Natom;
import ThematicModelProto.Theme;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThematicModelBuilder {
    public ArrayList<Theme> themes = new ArrayList();
    public ArrayList<Motif> motifs = new ArrayList();
    public ArrayList<Natom> natoms = new ArrayList();
    private Integer noise = 1;

    public static void main(String[] args) {
        String outputFile = "results.xml";
        Integer noise = 1;
        String themesFolder = ThematicModelBuilder.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        themesFolder = String.valueOf(themesFolder.replace("tmb.jar", "")) + "themes/";
        boolean brief = false;
        try {
            Integer selectionSize = new Integer(args[1]);
            ArrayList<String> themeNames = new ArrayList<String>();
            int i = 2;
            while (i < args.length) {
                if (args[i].equals("-noise")) {
                    noise = new Integer(args[++i]);
                } else if (args[i].equals("-o")) {
                    outputFile = args[++i];
                } else if (args[i].equals("-t")) {
                    themesFolder = args[++i];
                } else if (args[i].equals("-brief")) {
                    brief = true;
                } else {
                    themeNames.add(args[i]);
                }
                ++i;
            }
            ThematicModelBuilder tmb = new ThematicModelBuilder(themeNames, themesFolder, noise);
            tmb.loadFabula(args[0]);
            ArrayList<Natom> natoms = tmb.getStorySelection();
            String output = "";
            if (brief) {
                output = tmb.selectionToBriefList(natoms, selectionSize);
            } else {
                Document natomsDOM = tmb.selectionToXML(natoms, selectionSize);
                output = Helpers.xmlToString(natomsDOM);
            }
            if (outputFile.equals("-")) {
                System.out.println(output);
            } else {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
                    out.write(output);
                    out.close();
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
            if (noise > 1) {
                System.err.println("...Record successfully written.");
            }
        }
        catch (Exception e) {
            System.err.println(ThematicModelBuilder.getHelp());
        }
    }

    public ThematicModelBuilder(ArrayList<String> themes, String foldername, int noise) {
        this.noise = noise;
        if (noise > 1) {
            System.err.println("New Thematic Mode Builder started");
        }
        for (String themeName : themes) {
            Theme theme = new Theme(themeName, foldername);
            this.themes.add(theme);
            theme.getAllMotifs(this.motifs);
        }
    }

    public ThematicModelBuilder(ArrayList<String> themes, String foldername) {
        this(themes, foldername, 1);
    }

    public void loadFabula(String fabulaFile) {
        if (this.noise > 1) {
            System.err.println("Loading Fabula from: " + fabulaFile + " ...");
        }
        Document doc = Helpers.parseXmlFile(fabulaFile);
        NodeList natomElements = doc.getElementsByTagName("natom");
        int i = 0;
        while (i < natomElements.getLength()) {
            NodeList natomChildren = natomElements.item(i).getChildNodes();
            String id = "";
            String url = "";
            String author = "";
            HashSet<String> tags = new HashSet<String>();
            int k = 0;
            while (k < natomChildren.getLength()) {
                Node nn = natomChildren.item(k);
                String nname = nn.getNodeName();
                String value = nn.getTextContent();
                if (nname.equals("id")) {
                    id = value;
                }
                if (nname.equals("url")) {
                    url = value;
                }
                if (nname.equals("author")) {
                    author = value;
                }
                if (nname.equals("tags")) {
                    NodeList tnl = nn.getChildNodes();
                    int t = 0;
                    while (t < tnl.getLength()) {
                        Node tn = tnl.item(t);
                        if (tn.getNodeName().equals("tag")) {
                            tags.add(tn.getTextContent());
                        }
                        ++t;
                    }
                }
                ++k;
            }
            this.natoms.add(new Natom(id, url, tags, author));
            ++i;
        }
        if (this.noise > 1) {
            System.err.println("... Loaded Fabula");
        }
    }

    public HashMap<String, Integer> compileMotifListfoo(Theme theme) {
        HashMap<String, Integer> compiledList = new HashMap<String, Integer>();
        if (this.noise > 3) {
            System.err.println("Building motif list for " + theme.getName() + "...");
        }
        ArrayList<Motif> unpacked = new ArrayList<Motif>();
        theme.getAllMotifs(unpacked);
        int i = 0;
        while (i < unpacked.size()) {
            if (compiledList.containsKey(unpacked.get(i).getName())) {
                compiledList.put(unpacked.get(i).getName(), new Integer(compiledList.get(unpacked.get(i).getName()) + 1));
            } else {
                compiledList.put(unpacked.get(i).getName(), new Integer(1));
            }
            ++i;
        }
        return compiledList;
    }

    public double calculateComponentCoverage(ArrayList<Theme> themes, Natom natom) {
        double themesMatched = 0.0;
        for (Theme theme : themes) {
            ArrayList<Motif> motifs = new ArrayList<Motif>();
            theme.getFirstLevelMotifs(motifs);
            if (!this.motifsAreCovered(motifs, natom)) continue;
            themesMatched += 1.0;
        }
        return themesMatched / (double)themes.size();
    }

    public boolean motifsAreCovered(ArrayList<Motif> motifs, Natom natom) {
        HashSet<String> features = new HashSet<String>();
        for (Motif motif : motifs) {
            features.addAll(motif.getFeatures());
        }
        for (String tag : natom.getFeatures()) {
            if (!features.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public double calculateThematicCoverage(ArrayList<Theme> themes, Natom natom) {
        double themesMatched = 0.0;
        for (Theme theme : themes) {
            ArrayList<Motif> motifs = new ArrayList<Motif>();
            theme.getAllMotifs(motifs);
            if (!this.motifsAreCovered(motifs, natom)) continue;
            themesMatched += 1.0;
        }
        return themesMatched / (double)themes.size();
    }

    public ArrayList<Natom> getStorySelection() {
        for (Natom natom : this.natoms) {
            natom.thematicScore = this.calculateThematicCoverage(this.themes, natom);
            natom.componentScore = this.calculateComponentCoverage(this.themes, natom);
            natom.score = new Double(natom.thematicScore / 2.0 + natom.componentScore / 2.0);
        }
        Collections.sort(this.natoms);
        return this.natoms;
    }

    public Document selectionToXML(ArrayList<Natom> natoms, int size) {
        Document doc = Helpers.db.newDocument();
        System.out.println("Writing record xml...");
        Element natomsDOM = doc.createElement("natoms");
        doc.appendChild(natomsDOM);
        int i = 0;
        while (i < size) {
            natomsDOM.appendChild(natoms.get(i).toXML(doc));
            ++i;
        }
        return doc;
    }

    public String selectionToBriefList(ArrayList<Natom> natoms, int size) {
        String list = "";
        int i = 0;
        while (i < size) {
            list = String.valueOf(list) + natoms.get(i).getURL() + "\n";
            ++i;
        }
        return list;
    }

    public static String getHelp() {
        String help = "Thematic Model Builder Usage:\n";
        help = String.valueOf(help) + "\t tmb <fabula_file> <selection_size> <theme> [theme, theme, ...] [-o output_file] [-t theme_directory] [-noise int]";
        return help;
    }
}

