/*
 * Decompiled with CFR 0.152.
 */
package ThematicModelProto;

import ThematicModelProto.Helpers;
import ThematicModelProto.Motif;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Theme {
    private ArrayList<Theme> subthemes = new ArrayList();
    private ArrayList<Motif> motifs = new ArrayList();
    private String name;
    private String folder;

    public Theme(String name, String folder) {
        this.folder = folder;
        String file = String.valueOf(folder) + name + ".te";
        Document dom = Helpers.parseXmlFile(file);
        this.parseDocument(dom);
    }

    private void parseDocument(Document dom) {
        Element docEle = dom.getDocumentElement();
        this.name = docEle.getAttribute("name");
        NodeList nl = docEle.getChildNodes();
        if (nl == null) {
            return;
        }
        int i = 0;
        while (i < nl.getLength()) {
            Node el = nl.item(i);
            this.loadComponents(el);
            ++i;
        }
    }

    public ArrayList<String> loadComponents(Node el) {
        ArrayList<String> list = new ArrayList<String>();
        NodeList nl = el.getChildNodes();
        if (nl == null) {
            return list;
        }
        int i = 0;
        while (i < nl.getLength()) {
            block7: {
                String value;
                block6: {
                    String nname;
                    block5: {
                        Node n = nl.item(i);
                        nname = n.getNodeName();
                        value = n.getTextContent();
                        if (nname != "theme-component") break block5;
                        this.subthemes.add(new Theme(value, this.folder));
                        break block6;
                    }
                    if (nname != "motif-component") break block7;
                    this.motifs.add(new Motif(value, this.folder));
                }
                list.add(value.toLowerCase());
            }
            ++i;
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Theme> getThemes(ArrayList<Theme> allThemes) {
        allThemes.add(this);
        int i = 0;
        while (i < this.subthemes.size()) {
            this.subthemes.get(i).getThemes(allThemes);
            ++i;
        }
        return allThemes;
    }

    public ArrayList<Motif> getAllMotifs(ArrayList<Motif> allMotifs) {
        allMotifs.addAll(this.motifs);
        int i = 0;
        while (i < this.subthemes.size()) {
            this.subthemes.get(i).getAllMotifs(allMotifs);
            ++i;
        }
        return allMotifs;
    }

    public ArrayList<Motif> getChildMotifs() {
        return this.motifs;
    }

    public ArrayList<Motif> getFirstLevelMotifs(ArrayList<Motif> firstMotifs) {
        firstMotifs.addAll(this.motifs);
        for (Theme theme : this.subthemes) {
            firstMotifs.addAll(theme.getChildMotifs());
        }
        return firstMotifs;
    }
}

