import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

import org.xml.sax.SAXException;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photos.PhotosInterface;
import com.aetrion.flickr.photos.SearchParameters;
import com.aetrion.flickr.tags.Tag;

//import java.util.Date.*;

public class Expander{
	
	ArrayList<Natom> corpus;
	Term expansionTarget;
	HashMap<String, Double> cooccurProb;
	HashMap<String, Integer[]> cooccurCount;
	
	ArrayList<Term> terms;
	
	//HashMap<Natom, Float> natomDistance;
	
	//Timestamp ts = new Timestamp(0);
	
	long timeStart = System.currentTimeMillis();
	long timeGetCorpus;
	long timeCountCo;
	long timeCalcMut;
	long timeCalcDis;
	
	
	
	
	
	
	
	public Expander(){
		corpus = new ArrayList<Natom>();
		
		cooccurCount = new HashMap<String, Integer[]>();
		cooccurProb = new HashMap<String, Double>();
		
		terms=new ArrayList<Term>();
		
		//natomDistance = new HashMap<Natom, Float>();
		
	}
	
	public void buildCorpus(String seed, int size) throws IOException, SAXException, FlickrException{
		
		Flickr f = new Flickr("2e21c9b6c0c82892eff7e4e7ee0bd35d");
		
		PhotosInterface pi = new PhotosInterface("2e21c9b6c0c82892eff7e4e7ee0bd35d", f.getTransport());
		SearchParameters sp = new SearchParameters();
		
		sp.setText(seed);
		sp.setSort(sp.RELEVANCE);
		sp.setExtrasTags(true);
		System.out.println("Aquiring natoms using Flickr");
		System.out.println(seed+" as keyword with size "+size);
		System.out.println("Getting natoms for page 1");
		PhotoList pl = pi.search(sp, size, 1);
		for(int p =2; p<=(size/500); p++){
			System.out.println("Getting natoms for page "+p);
			pl.addAll(pi.search(sp, size, p));
		}
		
	
		System.out.println("PhotoList size "+pl.size());
		
		System.out.println("Writing natom classes...");
		
		int duplicates = 0;
		
		for(int i = 0; i<pl.size(); i++){
			Photo p = (Photo)pl.get(i);
			Iterator<Tag> ite = p.getTags().iterator();
			ArrayList<String> tagslist = new ArrayList<String>();
			while(ite.hasNext()){
				tagslist.add(ite.next().getValue().toLowerCase());
			}
			Natom n = new Natom(p.getId(), p.getSmallUrl(), tagslist, p.getOwner().getId());
			if(!corpus.contains(n)){
				corpus.add(n);
			}	
			
			
		}
		
		
		
		System.out.println("... natom classes written.");
		
		timeGetCorpus = System.currentTimeMillis();
		
	}
	
	
	public void expandMultiple(String corpusSeed, String[] termStrings, int corpusSize) throws IOException, SAXException, FlickrException{
	
		System.out.println("Expanding '"+termStrings+"' using corpus based on '"+corpusSeed+"' of size "+corpusSize);
		
		buildCorpus(corpusSeed, corpusSize);
		
		HashMap<String, HashMap<String, Double>> termDocs = new HashMap<String, HashMap<String, Double>>();  
		
		for(String termString:termStrings){
			expansionTarget=new Term(termString);
			System.out.println("Counting term frequencies ...");
			int natomc=1;
			for(Natom natom:corpus){
				System.out.println("... analysing natom "+natomc+" out of "+corpus.size()+" ... ");
				natomc++;
				if(natom.containsTag(termString)){
					for(String s:natom.tags){
						addCoOccur(true,s);					
					}
				}
				else{
					for(String s:natom.tags){
						addCoOccur(false,s);					
					}				
				}
			
					
			}
			System.out.println("... term frequencies counted.");
		
			timeCountCo = System.currentTimeMillis();
		
			calculateProbability();
			
			termDocs.put(termString, cooccurProb);
			
			cooccurCount = new HashMap<String, Integer[]>();
			cooccurProb = new HashMap<String, Double>();
			
			terms=new ArrayList<Term>();
		}
		
		HashMap<String, Double> finalCoProb = new HashMap<String, Double>();
		
		for(String termString: termStrings){
				
			for(String term:termDocs.get(termString).keySet()){
				
				if(finalCoProb.containsKey(term)){
					finalCoProb.put(term, finalCoProb.get(term)+(termDocs.get(termString).get(term)/termStrings.length));
				}
				else{
					finalCoProb.put(term, termDocs.get(termString).get(term)/termStrings.length);
				}
			}
			
			
		}
		
		cooccurProb = finalCoProb;
		
	}
	
	public void expand(String corpusSeed, String termString, int corpusSize) throws IOException, SAXException, FlickrException{
		
		System.out.println("Expanding '"+termString+"' using corpus based on '"+corpusSeed+"' of size "+corpusSize);
		
		expansionTarget=new Term(termString);
		buildCorpus(corpusSeed, corpusSize);
		
		System.out.println("Counting term frequencies ...");
		int natomc=1;
		for(Natom natom:corpus){
			System.out.println("... analysing natom "+natomc+" out of "+corpus.size()+" ... ");
			natomc++;
			if(natom.containsTag(termString)){
				for(String s:natom.tags){
					addCoOccur(true,s);					
				}
			}
			else{
				for(String s:natom.tags){
					addCoOccur(false,s);					
				}				
			}
			
					
		}
		System.out.println("... term frequencies counted.");
		
		timeCountCo = System.currentTimeMillis();
		
		calculateProbability();
		
	}
	
	public void addCoOccur(boolean c, String s){
		
		boolean isNew = true;
		int coi = 0;
		if(c)
			coi = 1;
		
		Term nt = new Term(s);
		
		if(cooccurCount.containsKey(nt.stem)){
			cooccurCount.put(nt.stem, new Integer[]{cooccurCount.get(nt.stem)[0]+1,cooccurCount.get(nt.stem)[1]+coi});
		}
		else
			cooccurCount.put(nt.stem, new Integer[]{1,coi});
		
		
		//old code
		/*
		for(Term t:cooccurCount.keySet()){
			if(t.isSimilar(new Term(s))){
				cooccurCount.put(t, new Integer[]{cooccurCount.get(t)[0]+1,cooccurCount.get(t)[1]+coi});
				if(t.stem.equals(expansionTarget.stem))
					expansionTarget=t;
				isNew = false;
			}
							
		}
		
		if(isNew){
			cooccurCount.put(new Term(s), new Integer[]{1,coi});
		}*/
		
		
	}
	
	
	public void calculateProbability(){
		
		System.out.println("Calculating term cooccurence probability ...");
		for(String stem:cooccurCount.keySet()){
			double pAB = cooccurCount.get(stem)[1];
			double pA = (cooccurCount.get(stem)[0]);
			double pB = 0.0;
			if(cooccurCount.containsKey(expansionTarget.stem))
				pB = (cooccurCount.get(expansionTarget.stem)[0]);
						
			double prob = 0.0;
			
			if(pAB>0&&pA>0&&pB>0){
				prob = Math.log((pAB/corpus.size())/((pA/corpus.size())*(pB/corpus.size())));
				cooccurProb.put(stem, Math.log((pAB/corpus.size())/((pA/corpus.size())*(pB/corpus.size()))));
			}
			else
				cooccurProb.put(stem, 0.0);
			
			Term t = new Term(stem);
			t.coProb=prob;
			
			terms.add(t);
			
			//stem.coProb=cooccurProb.get(stem);
		}
		System.out.println("... term cooccurence probability calculated.");
		
		timeCalcMut = System.currentTimeMillis();
		
	}
	
	
	public ArrayList<Term> sort(){
		System.out.println("Sorting terms based on cooccurence probability ...");		
		ArrayList<Term> sorted = terms;
		
		Collections.sort(sorted);
		System.out.println("... terms sorted.");		
		
		return sorted;
	}
	
	public ArrayList<Natom> search(int size){
		
		System.out.println("Creating a montage of size "+size+" ...");
		
		ArrayList<Natom> res = new ArrayList<Natom>();
		
		//HashMap<Natom, Float> distances = new HashMap<Natom, Float>();
		int i = 1;
		for(Natom n: corpus){
			System.out.println("... Calculating distance for natom "+i+" of "+corpus.size()+" ...");
			i++;
			HashMap<String, Integer> nTerms = getNatomTerms(n);
			double dis=0;
			for(String t:cooccurProb.keySet()){
				Integer natomTagFreq = 0;
				if(nTerms.containsKey(t))
					natomTagFreq=nTerms.get(t);
				dis+=Math.pow(cooccurProb.get(t)-natomTagFreq, 2);
			}
			dis=Math.sqrt(dis);
			//distances.put(n, dis);
			n.dis=dis;
		}
		
		Collections.sort(corpus);
		
		if(size>corpus.size())
			size=corpus.size();
		
		for(int s = 0; s<size; s++){
			res.add(corpus.get(s));			
		}
		
		System.out.println("... Montage created");
		
		timeCalcDis = System.currentTimeMillis();
		
		return res;
	}
	
	public HashMap<String, Integer> getNatomTerms(Natom n){
		
		HashMap<String, Integer> res = new HashMap<String, Integer>();
		
		for(String tag:n.tags){
			Term t = new Term(tag);
			if(res.containsKey(t.stem))
				res.put(t.stem, res.get(t.stem)+1);
			else
				res.put(t.stem, 1);
		}
		
		/*for(Term t:cooccurProb.keySet()){
			int count = 0;
			for(String tag:n.tags){
				Term temp = new Term(tag);
				if(t.isSimilar(temp))
					count++;
			}
			res.put(t, count);			
		}*/
		
		return res;
		
	}
	
	//in freq -Stem on construction of Term
	//in freq - Natom contains Term Frequency Hash
	//In dis - Loop tags*terms then fill with 0's
	
	//get rid of hash.getKeys();
	
}