import java.util.ArrayList;

public class Term implements Comparable<Term>{
	
	String term;
	
	String stem;
	String[] suffixs;
	
	double coProb;
	
	public Term(String t){
		
		suffixs= new String[4];
		
		term = t.toLowerCase();
		stem = stemming(term);
		
		
		coProb = 0.0;
		
	}
	
	public String stemming(String t){
		
		String result=t;
		
		suffixs[0] = "ly";
		suffixs[1] = "s";
		suffixs[2] = "ing";
		suffixs[3] = "y";
		
		for(String suf:suffixs){
			if(t.length()>suf.length()){
				if(t.substring(t.length()-suf.length()).equals(suf)){
				
					result = t.substring(0, t.length()-suf.length()).toLowerCase();
				
				}			
			}
		}
		
		
		return result;
				
	}
	
	public boolean isSimilar(Term t){
		
		boolean result = false;
		
		if(stem.equals(t.stem)){
			result=true;			
		}
		
		return result;
		
	}
	
	public int compareTo(Term t){
		
		if(coProb<t.coProb)
			return 1;
		else
			return 0;
		
	}
	
}