function [alpha,score]=KLIEP_learning_new(mean_X_tr,X_te)

[n_nu,nc]=size(X_te);
  
max_iteration=100;
epsilon_list=10.^[3:-1:-3];
b = mean_X_tr;
c=sum(b.^2);

% initilise
alpha=ones(nc,1);
score = 0;

for epsilon=epsilon_list
    for iteration=1:max_iteration

        alpha_t1 = alpha + epsilon * X_te' * (1./(X_te*alpha));

        alpha_t1 = alpha_t1 + b *(1-sum(b.*alpha_t1))/c;

        alpha_t1 = max(0,alpha_t1);

        alpha_t1 = alpha_t1 * pinv(sum(b.*alpha_t1),10^(-20));

        score_t1 = mean(log(X_te*alpha_t1));

        if (score_t1-score)<=0
            break;
        else
            score = score_t1;
            alpha = alpha_t1;
        end
    end
end

