function [gtruth,prdLbl,prd] = OvRSvmsSRG(upsample, ...
                                        trData, ...
                                        trLbl, ...
                                        teData, ...
                                        teLbl, ...
                                        options, ...
                                        IWscheme)
% 
% OvRSvms: This function will run Steeve Gun's SVMs in one-vs-rest configuration
% 
% [gtruth,prdLbl,prd] = OvRSvms(trdataset, tedataset, options)
% 
% trdataset.X = training data
% trdataset.Y = training labels
% tedataset.X = testing data
% tedataset.Y = testing labels
% options = SRG options, defult = 0.1
%
% gtruth = ground truth
% prdLbl = predicted labels
% prd = predicted probabilities 
% 
% Written by Ali Hassan (ah07r@ecs.soton.ac.uk)

if nargin < 7
    IWscheme = 'none';
end

if nargin < 6
        options = 0.1;
end

% X and Y, as above
trX = trData;
trY = trLbl;

teX = teData;
teY = teLbl;

%  number of classes
classlabels = unique(trY);
C = length(classlabels);

for c = 1:C
% learn C one-vs-rest classifier
    classlabel = classlabels(c);
    tronevsrestlabels = 2*(trY == classlabel)-1;

    if upsample == true % upsample the data
        ind = [1 1];
        [ntrX,ntronevsrestlabels]=OverSampling(trX',tronevsrestlabels',unique(tronevsrestlabels)',ind);
        ntrX = ntrX';
        ntronevsrestlabels = ntronevsrestlabels';
    elseif sum(tronevsrestlabels == 1) < size(teX,1)
        % downsample the training data so that non-target class equals target class
        % separate tar and non-target data
        tarX = trX(tronevsrestlabels == 1,:);
        ntarX = trX(tronevsrestlabels == -1,:);
        
        tarY = tronevsrestlabels(tronevsrestlabels == 1,:);
        ntarY = tronevsrestlabels(tronevsrestlabels == -1,:);
        
        idx = randperm(size(ntarX,1));
        
        % new training Data
        ntrX = [tarX; ntarX(idx(1:size(tarX,1)),:)];
        ntronevsrestlabels = [tarY;ntarY(idx(1:size(tarX,1)),:)];
        
        else % in case the training data is larger than the test
            ntrX = trX;
            ntronevsrestlabels = tronevsrestlabels;
    end
    
    % Calculating weights
    fprintf('Calculating weights ......');
    switch lower(IWscheme)
        case 'kmm'
            [weights EXITFLAG] = betaKMM(ntrX, [], teX, [], 0.1, false, false);
        case 'kliep'
            weights = KLIEP(ntrX',teX')';
        case 'ulsif'
            weights = uLSIF(ntrX',teX')';
        otherwise
            weights = ones(size(ntrX,1),1);
    end
    
    [nsv, alpha, b0] = modifiedsvc(ntrX, ...
                                    ntronevsrestlabels,...
                                    'linear',...
                                    options, ...
                                    weights);

% test one-vs-rest classifier    
    teonevsrestlabels = 2*(teY == classlabel)-1;
%     [prd,acc,p] = svmpredict2(teonevsrestlabels, teX, models{c}, '-b 1');
    p = modifiedsvcoutput(ntrX,ntronevsrestlabels,teX,'linear',alpha,b0,1);
    
    prob(:,c) = p;
    
end

% get the labels for max probability
[m,n] = max(prob,[],2);

gtruth = teY;
prdLbl = n-1;
prd = prob;

