function plotContour(Data, mn, S, clr)

% plotContour(Data, mn, S, clr)
% 
% Data = data for which the contour is to be plotted
% mn   = mean of the data
% S    = covariance matrix
% clr  = colour with witch the contour should be plotted
% 
% 
% Written by Ali Hassan (ah07r@ecs.soton.ac.uk)
% Date: 10 Jan 2010

if nargin < 3
    error('Not enought input arguments')
end
if nargin <4
    clr = 'g';
end

if (size(Data,2)<2)
    fprintf('Data must be two diamentional!!!!\n');
    return;
end

A = inv(S);

x = Data(:,1);
y = Data(:,2);
mn = mn;

xlin=linspace(min(x),max(x),100);
ylin=linspace(min(y),max(y),100);
[C1,C2]=meshgrid(xlin,ylin);
Z0 = 1/(2*pi*sqrt(det(S)))*exp(-0.5*(A(1,1)*(C1-mn(1)).^2 + 2*A(1,2)*(C1-mn(1)).*(C2-mn(2)) + A(2,2)*(C2-mn(2)).^2));

contour(xlin,ylin,Z0,1,clr,'LineWidth',2)