function [gtruth, prdLbl, prd, acc] = tenFCVOvR(upsample, ...
                                            Data,...
                                            Lbl, ...
                                            options, ...
                                            IWscheme)

% newtenFCVOvR: This function is going to run k-FCV on the data provided by
% using LibSVM classifier in One-vs-Rest configeration.
% 
% [gtruth, prdLbl, prd, acc] = tenFCVOvR(upsample, ...
%                                        Data,...
%                                        Lbl, ...
%                                        options, ...
%                                        IWscheme);
% 
% upsample = true/false Note: results in paper are produced with 
%             upsample = false
% Data     = input data
% Lbl      = class lbl
% options = penalty factor C in SVMs, default = 0.1
% IWscheme = 'kmm', 'ulsif', 'kliep' or 'none' (default)
% 
% gtruth = contains the true labels of the data. This will be different
%          from Lbl which is passed to the function as input parameter. 
%          It is different because of stratified cross validation
% prdLbl = predicted labels
% prd    = probabilities of each pridiction from SVMs
% acc    = [UAR WAR] accuracy per fold is this order

% 
% Written by Ali Hassan (ah07r@ecs.soton.ac.uk)

if nargin < 4
    options = 0.1;
elseif nargin < 5
    IWscheme = 'none';
end

t = cputime;

k = 10; % number of foldes to use

CV = cvpartition(Lbl,'kfold',k);

gtruth = [];    % Original Label
prdLbl = [];    % Predicted Label
gtruth2 = [];   % Original Label
prdLbl2 = [];    % Predicted Label
prd = [];       % Prediction Probability
prd2 = [];      % Prediction Probability
acc = [];

for i=1:k
    fprintf('Working on fold %i .... \n',i);
    
    teData = Data(CV.test(i),:);
    teLbl = Lbl(CV.test(i),:);
    
    trData = Data(CV.training(i),:);
    trLbl = Lbl(CV.training(i),:);
    
    trstruc.X = trData;
    trstruc.Y = trLbl;
    
    testruc.X = teData;
    testruc.Y = teLbl;
    
    [gt,pLbl,p] = OvRSvmsSRG(upsample, ...
                                trData,...
                                trLbl,...
                                teData, ...
                                teLbl, ...
                                options, ...
                                IWscheme);
    
    gtruth = [gtruth; gt];
    prdLbl = [prdLbl; pLbl];
    prd = [prd;p];
    c = confusionmat(gt,pLbl);
    
    acc(i,1) = UAR(teLbl,pLbl);
    acc(i,2) = WAR(teLbl,pLbl);
end

confusionmat(gtruth, prdLbl)

time = cputime - t

end

