% Test script to show how different methods work. In this test script, I am
% running SD-CV and SI-CV without upsampling and any importance weighting.
% If you want to run the script with weighting, just give the name of the
% IW scheme in the input parameter.
% 
% Due to copywrite reasons,  there is mat file in the Data folder.  You
% have to calculate it your self.  For caculating acoustic features, I am
% using OpenEAR toolkit.
% 
% Written by Ali Hassan (ah07r@ecs.soton.ac.uk)


addpath('../functions/',...
        '../KMM/',...
        '../KLIEP/',...
        '../uLSIF/',...
        '../svmSteeveGunnMod/')


load ../Data/DES5CLarge.mat
% This should load four variable, Data, Lbl, feat_name, wavname
% feat_name is optional


nData = normaliseData(Data); % normalise the data between 0-1
upsample = false;            % No upsampling
IWscheme = 'none';           % no importance weighting
options = 0.1;               % penalty value for SVM

% Run SD-CV (10-FCV) on the loaded data with no upsampling and no
% importance weighting scheme.  Other options for IWscheme are 'kmm',
% 'kliep' and 'ulsif'

[gtruth, prdLbl, prd, acc] = tenFCVOvR(upsample, ...
                                        nData,...
                                        Lbl, ...
                                        options, ...
                                        IWscheme);

% Run SI-CV on the loaded data with no upsampling and no importance 
% weighting scheme.  Other options for IWscheme are 'kmm', 'kliep' and 
% 'ulsif'

[gtruth, prdLbl, prd, acc] = siCVOvR(upsample, ...
                                          nData, ...
                                          Lbl, ...
                                          char(wavname), ...
                                          'des', ...
                                          'svm', ...
  										  0.1, ...
                                          'none');
  
  
