clear all, close all, randn('seed', 0), rand('seed', 0)
T1 = 30; T2 = 52; nl = 0.4;

sys0 = zpk(1, 0.9 * [exp(i * pi / 5) exp(-i * pi / 5)], 1, 1); ell = 2;
u1 = rand(T1, 1); y1 = lsim(sys0, u1); 
E = rand(T1, 2); w1 = [u1 y1] + nl * E / norm(E, 'fro') * norm([u1 y1], 'fro');

u2 = [zeros(ell, 1); 1; zeros(T2 - ell - 1, 1)];
y2 = [zeros(ell, 1); NaN * ones(T2 - ell, 1)]; w2 = [u2 y2];

tts = [blkhank(reshape(1:(T1 * 2), 2, T1), ell + 1) ...
       blkhank(reshape(T1 * 2 + (1:(T2 * 2)), 2 , T2), ell + 1)];
[wh, info] = slra_ext(tts, vec([w1' w2']), 2 * ell + 1);

y1h = wh(2:2:(2 * T1)); 

hh = wh(((T1 + ell) * 2 + 2):2:end); 
h0 = impulse(sys0, T2 - ell - 1);

addpath ~/mfiles/detss
hh_ = uy2h(w1(:, 1), w1(:, 2), ell, 7, T2 - ell)

figure(1)
plot(y1, '-r'), hold on, plot(w1(:, 2), 'ok'), plot(y1h, '--b')
ax = axis; axis([1, T2 - ell - 1, ax(3:4)]), print_fig('slra-ext-f3')

figure(2)
plot(hh(2:end), '--b'), hold on, plot(h0(2:end), '-r'), plot(hh_(2:end), '-.k'), 
ax = axis; axis([1, T2 - ell - 1, ax(3:4)]), print_fig('slra-ext-f2')
