clear all, randn('seed', 0), rand('seed', 0)
ell = 2; T = 50; Im = 1:(ell + 1):T; nl = 0.4;
sys0 = zpk(1, 0.9 * [exp(i * pi / 5) exp(-i * pi / 5)], 1, 1); 
y0 = impulse(sys0, T); y0 = y0(2:end);
e = randn(T, 1); y = y0 + nl * e / norm(e) * norm(y0); y(Im) = NaN;
tts = blkhank(1:T, ell + 1); Rini = [0.8 -1.5 1];
[yh, info] = slra_ext(tts, y, ell, [], Rini);
plot(y, 'ok'), hold on, 
plot(y0(1:T), 'r-'), plot(yh, 'b--')
ax = axis; 
plot(Im, ax(3) * ones(size(Im)), 'Xk', 'markersize', 15)
axis(ax), print_fig('slra-ext-f1')
