clear all, randn('seed', 0), rand('seed', 0)
m = 3; n = 10; r = 1; nl = 0.03; 
If = []; IM = [1 5 9 10 14 18 19 23 27]; 
addpath ~/mfiles/missing-data
addpath ~/mfiles/candes/matrix-completion/
addpath ~/mfiles/candes/matrix-completion/PROPACK_simple
p0 = rand(m, r) * rand(r, n); 
e  = randn(m, n); pf = p0 + nl * e / norm(e, 'fro') * norm(p0, 'fro');
np = m * n; tts = reshape(1:np, m, n); opt.method = 'reg'; % slra_ext calling parameters
tau = 5 * sqrt(m * n); % SVT calling parameters
for i = 1:length(IM)
  Im = IM(1:i); Ig = setdiff(1:np, Im); 
  w = ones(np, 1); w(Im) = 0; w(If) = inf;
  p = pf; p(If) = p0(If); p(Im) = NaN; 
  
  [ph, info] = slra_ext(tts, p(:), r, diag(w(Ig)), [], [], []);
  opt.g = norm(p(Ig)); 
  [ph_, info_] = slra_ext(tts, p(:), r, diag(w(Ig)), [], [], [], opt); 
  [Ph, Lh, info_wlra] = wlra(p, r, sqrt(reshape(w, m , n))); 
  delta = 1.2 / (length(Ig) / m / n); 
  [U, S, V, iter_svt] = SVT([m n], Ig, p(Ig), tau, delta, 10000);
  ph_svt  = U(:, 1:r) * S(1:r, 1:r) * V(:,1:r)';
  e = vec(p - ph_svt); fmin_svt = norm(sqrt(w(Ig)) .* e(Ig)) ^ 2;

  res_fmin(:, i) = [
  info.fmin       
  info_.fmin      
  info_wlra.err   
  fmin_svt        
  ];

  res_iter(:, i) = [
  info.iterations
  info_.iterations
  info_wlra.iter
  iter_svt
  ];
end  
res_fmin * 1e3, res_iter
