% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

% Calculate the UEC coding rate
% distribution is a string specifying the name of a distribution function, e.g. 'distribution_zeta'
% parameter is the parameter of that distribution
% n is the UEC codeword length
% threshold optionally respecifies the threshold that must be reached before terminating the infinite sum
% R is the UEC coding rate
function R = UEC_coding_rate(distribution, parameter, n, threshold)

    % See Eq (11) in (Maunder et al., 2013)
    if nargin < 4
        R = symbol_entropy(distribution, parameter)./average_unary_codeword_length(distribution, parameter)/n;
    else
        R = symbol_entropy(distribution, parameter, threshold)./average_unary_codeword_length(distribution, parameter, threshold)/n;
    end
    
end