% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at
% http://www.gnu.org/licenses/.



% The UEC decoder of Section IV in (Maunder et al., 2013)
% ztildea is the LLR matrix comprising n times b a priori LLRs pertaining to z, where LLR=ln[Pr(bit=1)/Pr(bit=0)]
% C is the set comprising r/2 codewords, each having n bits - e.g. C = [0 1; 1 1] in Fig 3(b) of (Maunder et al., 2013)
% Px_vector is a vector comprising the probabilities of the first r/2-1 symbol values
% l is the average unary codeword length
% a is the number of symbols to decode
% ztildee is the LLR matrix comprising n times b extrinsic LLRs pertaining to z, where LLR=ln[Pr(bit=1)/Pr(bit=0)]
% xhat is the symbol vector comprising a symbols
function [ztildee, xhat] = UEC_decoder(ztildea, C, Px_vector, l, a)

    [ztildee, ytildep] = trellis_decoder(ztildea, C, Px_vector, l, a);
    xhat = unary_decoder_soft(ytildep,a);
end