% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your 
% option) any later version.

% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.


% The H.264 distribution
% x is the symbol value
% mototonic is the parameter of the distribution
% Px is the probability corresponding to the specified symbol value

% If monotonic has a value of 0, then the H.264 probability distribution
% from Fig 1 in (Maunder et al., 2013) is used. If a value of 1 is used for 
% monotonic, then the H.264 probability distribution is sorted into
% monotonic order.
function Px = distribution_H264(x, monotonic)

    global P_H264;
    
    if size(P_H264,2) ~= 10000
        S = load('occurrences.mat');
        P_H264(1,:) = S.occurrences/sum(S.occurrences);
        
        P_H264(2,:) = sort(P_H264(1,:), 'descend');
    end
    
    Px = zeros(size(x));
    Px(x<=size(P_H264,2)) = P_H264(monotonic+1,x(x<=size(P_H264,2)));
    
end