% Generate Gaussian distributed a priori LLRs
% Copyright (C) 2010  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your 
% option) any later version.

% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

% Generates LLRs having a BEC distribution
% z is a vector of bits
% I is the desired mutual information in the range 0 to 1
% ztilde is a vector of LLRs, where LLR=ln[Pr(bit=1)/Pr(bit=0)]
function ztilde = generate_bec_llrs(z, I)

    if I < 0
        error('mutual information is too low!');
    elseif I > 1;
        error('mutual information is too high!');        
    elseif I == 0
        ztilde = zeros(size(z)); % Output a vector of c valued LLRs when the requested MI is 0
    elseif I == 1;
       ztilde = (2*z-1)*100; % Output a vector of infinite valued LLRs when the requested MI is 1
    else
        
        pe = 1-I;
        
        ztilde = (2*z-1)*100;
        erasures = rand(size(ztilde))<pe;
        ztilde(erasures) = 0;
        
    end
        
end

