% FLC decoder
% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

function [utildee, t_hat] = FLC_decoder(utildea, x_hat, P_t_given_x_vector)

if length(utildea) ~= sum(x_hat) - length(x_hat)
    error('length(utildea) should equal sum(x_hat) - length(x_hat)');
end

bit_index = 1;
utildee = zeros(size(utildea));
t_hat = zeros(size(x_hat));
for symbol_index = 1:length(x_hat)
    d = (2^(x_hat(symbol_index)-1)):(2^x_hat(symbol_index)-1);
    
    symbol_probabilities = P_t_given_x_vector(d(d<=length(P_t_given_x_vector)));
    symbol_probabilities = [symbol_probabilities, ones(1,length(d) - length(symbol_probabilities))*(1-sum(symbol_probabilities))/(length(d) - length(symbol_probabilities))];
    
    apriori_llrs = utildea(bit_index:bit_index + x_hat(symbol_index)-2);
    
    
    codewords = zeros(length(symbol_probabilities),length(apriori_llrs));
    for symbol_index2 = 2:length(symbol_probabilities)
        codewords(symbol_index2,:) = dec2bin(symbol_index2-1,length(apriori_llrs))-'0';
    end
    
    log_symbol_probabilities = log(symbol_probabilities);
    for bit_index2 = 1:size(codewords,2)
        log_symbol_probabilities(codewords(:,bit_index2)==1)=log_symbol_probabilities(codewords(:,bit_index2)==1) + apriori_llrs(bit_index2);
    end
    
    [~,max_index] = max(log_symbol_probabilities);
    t_hat(symbol_index) = max_index-1;
    
    if max(symbol_probabilities) ~= min(symbol_probabilities)
        
        
        log_p0 = zeros(size(apriori_llrs));
        log_p1 = zeros(size(apriori_llrs));
        for bit_index2 = 1:size(codewords,2)
            log_p0(bit_index2) = maxstar(log_symbol_probabilities(codewords(:,bit_index2) == 0));
            log_p1(bit_index2) = maxstar(log_symbol_probabilities(codewords(:,bit_index2) == 1));
        end
        extrinsic_llrs = log_p1 -log_p0 - apriori_llrs;
        
        utildee(bit_index:bit_index + x_hat(symbol_index)-2) = extrinsic_llrs;
        
    end
    
    
    bit_index = bit_index + x_hat(symbol_index)-1;
    
end