% FLC encoder
% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

function u = FLC_encoder(x,t)

if ~isequal(size(x),size(t))
    error('x and t should have the same size');
end

u = zeros(1,sum(x) - length(x));

bit_index = 1;

for symbol_index = 1:length(x)
    
    u(bit_index:bit_index + x(symbol_index)-2) = dec2bin(t(symbol_index),x(symbol_index)-1) - '0';
    
    bit_index = bit_index + x(symbol_index)-1;
    
end

