% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

% The UEC trellis encoder of Section III-B in (Maunder et al., 2013)
% y is the bit vector comprising b bits, formed of concatenated unary codewords
% C is the set comprising r/2 codewords, each having n bits - e.g. C = [0 1; 1 1] in Fig 3(b) of (Maunder et al., 2013)
% z is the UEC-encoded bit vector comprising bn bits
function z = UEC_trellis_encoder(y,C)

% Determine the number of states
r = 2*size(C,1);

% Always start from a previous state of 1 
mprime = 1;

% Perform the trellis encoding
z = zeros(size(C,2),length(y));
for j = 1:length(y)
    
    odd = mod(mprime,2);
    
    % Determine the next state
    if y(j) == 1
        m = 1 + odd;
    else
        m = min(mprime+2,r - odd);
    end
    
    % Select the corresponding codeword
    if y(j) ~= odd
        z(:,j) = ~C(ceil(mprime/2), :);
    else
        z(:,j) = C(ceil(mprime/2), :);
    end
    
    % Enter the next state
    mprime = m;
end
      