% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

% Calculate an expected value for the area beneath the inverted UEC EXIT curve
% Px_vector is a vector comprising the probabilities of the first r/2-1 symbol values
% l is the average unary codeword length
% n is the UEC codeword length
function A = get_A_1(Px_vector, l, n)

    % See Eq (14) in (Maunder et al., 2013)
    A = (sum(information(Px_vector))+2*information(1-sum(Px_vector))+information(l-length(Px_vector)-1+sum(Px_vector.*(length(Px_vector)+1-(1:length(Px_vector)))))-information(l-length(Px_vector)+sum(Px_vector.*(length(Px_vector)-(1:length(Px_vector))))))/(l*n);

end