% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

function A_2 = get_A_2(s,n_2,x_max,threshold)

if nargin < 4
    threshold = 1e-10;
end

l_2 = get_l_2(s,threshold);

A_2 = 0;
total_frac = 0;

for x = 2:x_max
    t = 0:2^(x-1)-1; 
    P_t_given_x = get_P_t_given_x(t,x,s);
    
    H = sum(P_t_given_x.*log2(1./P_t_given_x));
    l = x-1;
    
    R = H/l;

    fraction_of_bits = (x-1)*get_P_x(x,s)/l_2;
    
    A_2 = A_2 + R*fraction_of_bits;
    total_frac = total_frac+fraction_of_bits;

end

A_2 = (A_2 + 1-total_frac)/n_2;