% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

function H_T_given_X = get_H_T_given_X(s, threshold)



            if nargin < 2
                threshold = 1e-10;
            end

            H_T_given_X = 0;
            keepgoing = 1;
            x=2;

            while keepgoing

                t = 0:(2^(x-1)-1);
                
                temp = get_P_t_and_x(t,x,s).*log2(1./get_P_t_given_x(t,x,s));

                H_T_given_X = H_T_given_X + sum(temp);

                if(temp(end) < threshold)
                    keepgoing = 0;
                else
                    x = x + 1;
                end
            end
           