% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

function H_X = get_H_X(s, threshold)



            if nargin < 2
                threshold = 1e-10;
            end

            H_X = 0;
            keepgoing = 1;
            x=2;

            while keepgoing

                d = (2^(x-1)):(2^x-1);
                
                temp = -sum(d.^-s)*log2(sum(d.^-s));

                H_X = H_X + temp;

                if(temp < threshold)
                    keepgoing = 0;
                else
                    x = x + 1;
                end
            end
            
            H_X = log2(zeta(s))+H_X/zeta(s);
