% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your
% option) any later version.

% This program is distributed in the hope that it will be useful, but
% WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

function l_1 = get_l_1(s, threshold)

            
            if nargin < 2
                threshold = 1e-10;
            end

            symbol_count = 1000000;
            l_1 = 0;
            keepgoing = 1;
            symbol_indices = 1:symbol_count;

            % See Eq (5) in (Maunder et al., 2013)
            while keepgoing

                temp = (symbol_indices.^-s).*(log2(symbol_indices)-floor(log2(symbol_indices)));

                l_1 = l_1 + sum(temp);

                if(temp(end) < threshold)
                    keepgoing = 0;
                else
                    symbol_indices = symbol_indices + symbol_count;
                end
            end
            
            zeta_s = zeta(s);
            l_1 = 1-zeta(1,s)/zeta_s/log(2)-l_1/zeta_s;

            
end