﻿* DESCRIPTIVE ANALYSIS 

* Time of questionnaire completion.

FREQUENCIES VARIABLES=TotalTimeTaken
  /FORMAT=NOTABLE
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Planning data management".

COMPUTE plandtmg=PDMS1.Q1.1 + PDMS1.Q1.2 + PDMS1.Q1.3 + PDMS1.Q1.4 + PDMS1.Q1.5 + PDMS1.Q1.6 - 6.
VARIABLE LABELS plandtmg 'Index of confidence for planning data management'.
FREQUENCIES VARIABLES=plandtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=plandtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: plandtmg=col(source(s), name("plandtmg"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for planning data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(plandtmg, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Planning data management.

FREQUENCIES VARIABLES=PDMS1.Q1.1	PDMS1.Q1.2	PDMS1.Q1.3	PDMS1.Q1.4	PDMS1.Q1.5	PDMS1.Q1.6
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Data Management during the research process".

COMPUTE dtmgdrp=DMRPS1.Q2.1 +	DMRPS1.Q2.2	+ DMRPS1.Q2.3	+ DMRPS1.Q2.4 - 4.
VARIABLE LABELS dtmgdrp 'Index of confidence for data management during the research process'.
FREQUENCIES VARIABLES=dtmgdrp
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=dtmgdrp MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: dtmgdrp=col(source(s), name("dtmgdrp"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for data management during the research process"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(dtmgdrp, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Data Management during the research process.

FREQUENCIES VARIABLES=DMRPS1.Q2.1	DMRPS1.Q2.2	DMRPS1.Q2.3	DMRPS1.Q2.4
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Post Research Data Management".

COMPUTE ptrsdtmg= PRDMS1.Q3.1 +	PRDMS1.Q3.2	+ PRDMS1.Q3.3 +	PRDMS1.Q3.4 +	PRDMS1.Q3.5 - 5.
VARIABLE LABELS ptrsdtmg 'Index of confidence for post research data management'.
FREQUENCIES VARIABLES=ptrsdtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=ptrsdtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: ptrsdtmg=col(source(s), name("ptrsdtmg"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for post research data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(ptrsdtmg, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Data Management during the research process.

FREQUENCIES VARIABLES=PRDMS1.Q3.1	PRDMS1.Q3.2	PRDMS1.Q3.3	PRDMS1.Q3.4	PRDMS1.Q3.5
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



************************************
* String analysis variable S1.FT.
************************************



* Generate an overall index of confidence for "Directing researchers to the right person: Planning data management".

recode PDMS2.Q1.1 (1 thru 7 = copy) (else = sysmis) into pdm5r. 
recode PDMS2.Q1.2 (1 thru 7 = copy) (else = sysmis) into pdm6r. 
recode PDMS2.Q1.3 (1 thru 7 = copy) (else = sysmis) into pdm7r. 
recode PDMS2.Q1.4 (1 thru 7 = copy) (else = sysmis) into pdm8r. 
recode PDMS2.Q1.5 (1 thru 7 = copy) (else = sysmis) into pdm9r. 
recode PDMS2.Q1.6 (1 thru 7 = copy) (else = sysmis) into pdm01r. 
COMPUTE drpldtmg=MEAN(pdm5r,pdm6r,pdm7r,pdm8r,pdm9r,pdm01r).
VARIABLE LABELS drpldtmg 'Index of confidence for directing researchers to the right person in planning data management'.
FREQUENCIES VARIABLES=drpldtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drpldtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drpldtmg=col(source(s), name("drpldtmg"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in planning data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drpldtmg, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in planning data management.

FREQUENCIES VARIABLES=pdm5r pdm6r pdm7r pdm8r pdm9r pdm01r
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
recode PDMS2.Q1.1 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into pdm5r2. 
recode PDMS2.Q1.2 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into pdm6r2. 
recode PDMS2.Q1.3 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into pdm7r2. 
recode PDMS2.Q1.4 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into pdm8r2. 
recode PDMS2.Q1.5 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into pdm9r2. 
recode PDMS2.Q1.6 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into pdm01r2. 
FREQUENCIES VARIABLES=pdm5r2 pdm6r2 pdm7r2 pdm8r2 pdm9r2 pdm01r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
COMPUTE myrole1=SUM(pdm5r2,pdm6r2,pdm7r2,pdm8r2,pdm9r2,pdm01r2).
FREQUENCIES VARIABLES=myrole1
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
RECODE PDMS2.Q2.1 ('Yes'='1') ('No'='0').
RECODE PDMS2.Q2.2 ('Yes'='1') ('No'='0').
RECODE PDMS2.Q2.3 ('Yes'='1') ('No'='0').
RECODE PDMS2.Q2.4 ('Yes'='1') ('No'='0').
RECODE PDMS2.Q2.5 ('Yes'='1') ('No'='0').
RECODE PDMS2.Q2.6 ('Yes'='1') ('No'='0').
ALTER TYPE  PDMS2.Q2.1(F15.0) PDMS2.Q2.2(F15.0) PDMS2.Q2.3(F15.0) PDMS2.Q2.4(F15.0) PDMS2.Q2.5(F15.0) PDMS2.Q2.6(F15.0).
FORMATS  PDMS2.Q2.1(F15.0) PDMS2.Q2.2(F15.0) PDMS2.Q2.3(F15.0) PDMS2.Q2.4(F15.0) PDMS2.Q2.5(F15.0) PDMS2.Q2.6(F15.0).
VARIABLE LEVEL  PDMS2.Q2.1(SCALE)	PDMS2.Q2.2(SCALE)	PDMS2.Q2.3(SCALE)	PDMS2.Q2.4(SCALE)	PDMS2.Q2.5(SCALE)	PDMS2.Q2.6(SCALE).
FREQUENCIES VARIABLES=PDMS2.Q2.1	PDMS2.Q2.2	PDMS2.Q2.3	PDMS2.Q2.4	PDMS2.Q2.5	PDMS2.Q2.6 
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Directing researchers to the right person: Data management during the research process".

recode DMRPS2.Q3.1 (1 thru 7 = copy) (else = sysmis) into dmrp3r. 
recode DMRPS2.Q3.2 (1 thru 7 = copy) (else = sysmis) into dmrp4r. 
recode DMRPS2.Q3.3 (1 thru 7 = copy) (else = sysmis) into dmrp5r. 
recode DMRPS2.Q3.4 (1 thru 7 = copy) (else = sysmis) into dmrp6r. 
COMPUTE drdtmgdu=MEAN(dmrp5r,dmrp6r,dmrp4r,dmrp3r).
VARIABLE LABELS drdtmgdu 'Index of confidence for directing researchers to the right person in data management during the research process'.
FREQUENCIES VARIABLES=drdtmgdu
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drdtmgdu MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drdtmgdu=col(source(s), name("drdtmgdu"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in data management during the research process"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drdtmgdu, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in data management during the research process.

FREQUENCIES VARIABLES= dmrp3r dmrp4r dmrp5r dmrp6r 
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
recode DMRPS2.Q3.1 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into dmrp3r2. 
recode DMRPS2.Q3.2 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into dmrp4r2. 
recode DMRPS2.Q3.3 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into dmrp5r2. 
recode DMRPS2.Q3.4 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into dmrp6r2. 
FREQUENCIES VARIABLES=dmrp3r2 dmrp4r2 dmrp5r2 dmrp6r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
COMPUTE myrole2=SUM(dmrp3r2,dmrp4r2,dmrp5r2,dmrp6r2).
FREQUENCIES VARIABLES=myrole2
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
RECODE DMRPS2.Q4.1 ('Yes'='1') ('No'='0').
RECODE DMRPS2.Q4.2 ('Yes'='1') ('No'='0').
RECODE DMRPS2.Q4.3 ('Yes'='1') ('No'='0').
RECODE DMRPS2.Q4.4 ('Yes'='1') ('No'='0').
ALTER TYPE  DMRPS2.Q4.1(F15.0)	DMRPS2.Q4.2(F15.0)	DMRPS2.Q4.3(F15.0)	DMRPS2.Q4.4(F15.0).
FORMATS  DMRPS2.Q4.1(F15.0)	DMRPS2.Q4.2(F15.0)	DMRPS2.Q4.3(F15.0)	DMRPS2.Q4.4(F15.0).
VARIABLE LEVEL  DMRPS2.Q4.1(SCALE)	DMRPS2.Q4.2(SCALE)	DMRPS2.Q4.3(SCALE)	DMRPS2.Q4.4(SCALE).
FREQUENCIES VARIABLES=DMRPS2.Q4.1	DMRPS2.Q4.2	DMRPS2.Q4.3	DMRPS2.Q4.4
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Directing researchers to the right person: Post research data management".

recode PRDMS2.Q5.1 (1 thru 7 = copy) (else = sysmis) into prdm4r. 
recode PRDMS2.Q5.2 (1 thru 7 = copy) (else = sysmis) into prdm5r. 
recode PRDMS2.Q5.3 (1 thru 7 = copy) (else = sysmis) into prdm6r. 
recode PRDMS2.Q5.4 (1 thru 7 = copy) (else = sysmis) into prdm7r. 
recode PRDMS2.Q5.5 (1 thru 7 = copy) (else = sysmis) into prdm8r. 
COMPUTE drptdtmg=MEAN(prdm4r,prdm5r,prdm6r,prdm7r,prdm8r).
VARIABLE LABELS drptdtmg 'Index of confidence for directing researchers to the right person in post research data management'.
FREQUENCIES VARIABLES=drptdtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drptdtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drptdtmg=col(source(s), name("drptdtmg"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in post research data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drptdtmg, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in post research data management.

FREQUENCIES VARIABLES= prdm4r prdm5r prdm6r prdm7r prdm8r
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
recode PRDMS2.Q5.1 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into prdm4r2. 
recode PRDMS2.Q5.2 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into prdm5r2. 
recode PRDMS2.Q5.3 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into prdm6r2. 
recode PRDMS2.Q5.4 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into prdm7r2. 
recode PRDMS2.Q5.5 (9999 = 1) (1 thru 7 = 0) (else = sysmis) into prdm8r2. 
FREQUENCIES VARIABLES=prdm4r2 prdm5r2 prdm6r2 prdm7r2 prdm8r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
COMPUTE myrole3=SUM(prdm4r2,prdm5r2,prdm6r2,prdm7r2,prdm8r2).
FREQUENCIES VARIABLES=myrole3
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
RECODE PRDMS2.Q6.1 ('Yes'='1') ('No'='0').
RECODE PRDMS2.Q6.2 ('Yes'='1') ('No'='0').
RECODE PRDMS2.Q6.3 ('Yes'='1') ('No'='0').
RECODE PRDMS2.Q6.4 ('Yes'='1') ('No'='0').
RECODE PRDMS2.Q6.5 ('Yes'='1') ('No'='0').
ALTER TYPE  PRDMS2.Q6.1(F15.0)	PRDMS2.Q6.2(F15.0)	PRDMS2.Q6.3(F15.0)	PRDMS2.Q6.4(F15.0)	PRDMS2.Q6.5(F15.0).
FORMATS  PRDMS2.Q6.1(F15.0)	PRDMS2.Q6.2(F15.0)	PRDMS2.Q6.3(F15.0)	PRDMS2.Q6.4(F15.0)	PRDMS2.Q6.5(F15.0).
VARIABLE LEVEL  PRDMS2.Q6.1(SCALE)	PRDMS2.Q6.2(SCALE)	PRDMS2.Q6.3(SCALE)	PRDMS2.Q6.4(SCALE)	PRDMS2.Q6.5(SCALE).
FREQUENCIES VARIABLES=PRDMS2.Q6.1	PRDMS2.Q6.2	PRDMS2.Q6.3	PRDMS2.Q6.4	PRDMS2.Q6.5
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



************************************
* String analysis variable S2.FG.
************************************



* Descriptive statistics of the questionnaire's final section.

FREQUENCIES VARIABLES=AYS3.Q1 
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q2.
************************************



FREQUENCIES VARIABLES=AYS3.Q3.1	AYS3.Q3.2	AYS3.Q3.3	AYS3.Q4.1
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q4.1a.
************************************


FREQUENCIES VARIABLES=AYS3.Q5.1
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q5.1a	AYS3.Q5.1b	RDMS3.Q6.
************************************



*****************************************************************************************************************************************************.
*********************************************** Analysis for Library members *****************************************************************.
*****************************************************************************************************************************************************.



USE ALL.
COMPUTE filter_$=(AYS3.Q1 = 'Library').
VARIABLE LABELS filter_$ "AYS3.Q1 = 'Library' (FILTER)".
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.



* DESCRIPTIVE ANALYSIS 

* Time of questionnaire completion.

FREQUENCIES VARIABLES=TotalTimeTaken
  /FORMAT=NOTABLE
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Planning data management".

FREQUENCIES VARIABLES=plandtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=plandtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: plandtmg=col(source(s), name("plandtmg"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for planning data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(plandtmg, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Planning data management.

FREQUENCIES VARIABLES=PDMS1.Q1.1	PDMS1.Q1.2	PDMS1.Q1.3	PDMS1.Q1.4	PDMS1.Q1.5	PDMS1.Q1.6
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Data Management during the research process".

FREQUENCIES VARIABLES=dtmgdrp
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=dtmgdrp MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: dtmgdrp=col(source(s), name("dtmgdrp"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for data management during the research process"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(dtmgdrp, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Data Management during the research process.

FREQUENCIES VARIABLES=DMRPS1.Q2.1	DMRPS1.Q2.2	DMRPS1.Q2.3	DMRPS1.Q2.4
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Post Research Data Management".

FREQUENCIES VARIABLES=ptrsdtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=ptrsdtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: ptrsdtmg=col(source(s), name("ptrsdtmg"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for post research data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(ptrsdtmg, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Data Management during the research process.

FREQUENCIES VARIABLES=PRDMS1.Q3.1	PRDMS1.Q3.2	PRDMS1.Q3.3	PRDMS1.Q3.4	PRDMS1.Q3.5
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



************************************
* String analysis variable S1.FT.
************************************



* Generate an overall index of confidence for "Directing researchers to the right person: Planning data management".

FREQUENCIES VARIABLES=drpldtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drpldtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drpldtmg=col(source(s), name("drpldtmg"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in planning data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drpldtmg, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in planning data management.

FREQUENCIES VARIABLES=pdm5r pdm6r pdm7r pdm8r pdm9r pdm01r
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
FREQUENCIES VARIABLES=pdm5r2 pdm6r2 pdm7r2 pdm8r2 pdm9r2 pdm01r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
FREQUENCIES VARIABLES=myrole1
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
FREQUENCIES VARIABLES=PDMS2.Q2.1	PDMS2.Q2.2	PDMS2.Q2.3	PDMS2.Q2.4	PDMS2.Q2.5	PDMS2.Q2.6 
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Directing researchers to the right person: Data management during the research process".

FREQUENCIES VARIABLES=drdtmgdu
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drdtmgdu MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drdtmgdu=col(source(s), name("drdtmgdu"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in data management during the research process"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drdtmgdu, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in data management during the research process.

FREQUENCIES VARIABLES= dmrp3r dmrp4r dmrp5r dmrp6r 
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
FREQUENCIES VARIABLES=dmrp3r2 dmrp4r2 dmrp5r2 dmrp6r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
FREQUENCIES VARIABLES=myrole2
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
FREQUENCIES VARIABLES=DMRPS2.Q4.1	DMRPS2.Q4.2	DMRPS2.Q4.3	DMRPS2.Q4.4
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Directing researchers to the right person: Post research data management".

FREQUENCIES VARIABLES=drptdtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drptdtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drptdtmg=col(source(s), name("drptdtmg"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in post research data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drptdtmg, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in post research data management.

FREQUENCIES VARIABLES= prdm4r prdm5r prdm6r prdm7r prdm8r
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
FREQUENCIES VARIABLES=prdm4r2 prdm5r2 prdm6r2 prdm7r2 prdm8r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
FREQUENCIES VARIABLES=myrole3
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
FREQUENCIES VARIABLES=PRDMS2.Q6.1	PRDMS2.Q6.2	PRDMS2.Q6.3	PRDMS2.Q6.4	PRDMS2.Q6.5
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



************************************
* String analysis variable S2.FG.
************************************



* Descriptive statistics of the questionnaire's final section.

FREQUENCIES VARIABLES=AYS3.Q1 
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q2.
************************************



FREQUENCIES VARIABLES=AYS3.Q3.1	AYS3.Q3.2	AYS3.Q3.3	AYS3.Q4.1
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q4.1a.
************************************


FREQUENCIES VARIABLES=AYS3.Q5.1
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q5.1a	AYS3.Q5.1b	RDMS3.Q6.
************************************



*****************************************************************************************************************************************************.
*********************************************** Analysis for Other respondents *****************************************************************.
*****************************************************************************************************************************************************.



USE ALL.
COMPUTE filter_$=(AYS3.Q1 = 'iSolutions' | AYS3.Q1 = 'Research and Innovation Services').
VARIABLE LABELS filter_$ "AYS3.Q1 = 'iSolutions' | ay = 'Research and Innovation Services' (FILTER)".
VALUE LABELS filter_$ 0 'Not Selected' 1 'Selected'.
FORMATS filter_$ (f1.0).
FILTER BY filter_$.



* DESCRIPTIVE ANALYSIS 

* Time of questionnaire completion.

FREQUENCIES VARIABLES=TotalTimeTaken
  /FORMAT=NOTABLE
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Planning data management".

FREQUENCIES VARIABLES=plandtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=plandtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: plandtmg=col(source(s), name("plandtmg"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for planning data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(plandtmg, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Planning data management.

FREQUENCIES VARIABLES=PDMS1.Q1.1	PDMS1.Q1.2	PDMS1.Q1.3	PDMS1.Q1.4	PDMS1.Q1.5	PDMS1.Q1.6
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Data Management during the research process".

FREQUENCIES VARIABLES=dtmgdrp
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=dtmgdrp MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: dtmgdrp=col(source(s), name("dtmgdrp"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for data management during the research process"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(dtmgdrp, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Data Management during the research process.

FREQUENCIES VARIABLES=DMRPS1.Q2.1	DMRPS1.Q2.2	DMRPS1.Q2.3	DMRPS1.Q2.4
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Post Research Data Management".

FREQUENCIES VARIABLES=ptrsdtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=ptrsdtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: ptrsdtmg=col(source(s), name("ptrsdtmg"))
  GUIDE: axis(dim(1), delta(5), label("Index of confidence for post research data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(ptrsdtmg, binWidth(5)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Data Management during the research process.

FREQUENCIES VARIABLES=PRDMS1.Q3.1	PRDMS1.Q3.2	PRDMS1.Q3.3	PRDMS1.Q3.4	PRDMS1.Q3.5
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



************************************
* String analysis variable S1.FT.
************************************



* Generate an overall index of confidence for "Directing researchers to the right person: Planning data management".

FREQUENCIES VARIABLES=drpldtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drpldtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drpldtmg=col(source(s), name("drpldtmg"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in planning data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drpldtmg, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in planning data management.

FREQUENCIES VARIABLES=pdm5r pdm6r pdm7r pdm8r pdm9r pdm01r
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
FREQUENCIES VARIABLES=pdm5r2 pdm6r2 pdm7r2 pdm8r2 pdm9r2 pdm01r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
FREQUENCIES VARIABLES=myrole1
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
FREQUENCIES VARIABLES=PDMS2.Q2.1	PDMS2.Q2.2	PDMS2.Q2.3	PDMS2.Q2.4	PDMS2.Q2.5	PDMS2.Q2.6 
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Directing researchers to the right person: Data management during the research process".

FREQUENCIES VARIABLES=drdtmgdu
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drdtmgdu MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drdtmgdu=col(source(s), name("drdtmgdu"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in data management during the research process"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drdtmgdu, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in data management during the research process.

FREQUENCIES VARIABLES= dmrp3r dmrp4r dmrp5r dmrp6r 
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
FREQUENCIES VARIABLES=dmrp3r2 dmrp4r2 dmrp5r2 dmrp6r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
FREQUENCIES VARIABLES=myrole2
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
FREQUENCIES VARIABLES=DMRPS2.Q4.1	DMRPS2.Q4.2	DMRPS2.Q4.3	DMRPS2.Q4.4
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



* Generate an overall index of confidence for "Directing researchers to the right person: Post research data management".

FREQUENCIES VARIABLES=drptdtmg
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM SEMEAN MEAN MEDIAN
  /ORDER=ANALYSIS.

GGRAPH
  /GRAPHDATASET NAME="graphdataset" VARIABLES=drptdtmg MISSING=LISTWISE REPORTMISSING=NO
  /GRAPHSPEC SOURCE=INLINE.
BEGIN GPL
  SOURCE: s=userSource(id("graphdataset"))
  DATA: drptdtmg=col(source(s), name("drptdtmg"))
  GUIDE: axis(dim(1), delta(2), label("Index of confidence for directing researchers to the right person in post research data management"))
  GUIDE: axis(dim(2), label("Percentage"))
  ELEMENT: interval(position(summary.percent.count(bin.rect(drptdtmg, binWidth(1)), 
    base.all(acrossPanels()))), shape.interior(shape.square))
END GPL.

* Descriptive statistics of each component regarding Directing researchers to the right person in post research data management.

FREQUENCIES VARIABLES= prdm4r prdm5r prdm6r prdm7r prdm8r
  /FORMAT=NOTABLE
  /NTILES=4
  /STATISTICS=STDDEV MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.

* Descriptive statistics of how many people replied that a single item identified their role.
FREQUENCIES VARIABLES=prdm4r2 prdm5r2 prdm6r2 prdm7r2 prdm8r2
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.
FREQUENCIES VARIABLES=myrole3
  /FORMAT=NOTABLE
  /STATISTICS= MINIMUM MAXIMUM MEAN MEDIAN
  /ORDER=ANALYSIS.



* Descriptive statistics of areas respondents should be aware of in Planning data management.
FREQUENCIES VARIABLES=PRDMS2.Q6.1	PRDMS2.Q6.2	PRDMS2.Q6.3	PRDMS2.Q6.4	PRDMS2.Q6.5
  /FORMAT=NOTABLE
  /STATISTICS= MEAN SUM
  /ORDER=ANALYSIS.



************************************
* String analysis variable S2.FG.
************************************



* Descriptive statistics of the questionnaire's final section.

FREQUENCIES VARIABLES=AYS3.Q1 
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q2.
************************************



FREQUENCIES VARIABLES=AYS3.Q3.1	AYS3.Q3.2	AYS3.Q3.3	AYS3.Q4.1
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q4.1a.
************************************


FREQUENCIES VARIABLES=AYS3.Q5.1
  /ORDER=ANALYSIS.



************************************
* String analysis variable AYS3.Q5.1a	AYS3.Q5.1b	RDMS3.Q6.
************************************



FILTER OFF.
USE ALL.

