set term pslatex
set output '2dexit.tex' 
set size square 1.25,1.25

#set lmargin 19
#set bmargin 3
#set rmargin 2
#set tmargin 1

set format y '$10^{%T}$'
set log y
set xrange [-4:6]
set yrange [1e-5:1]




set multiplot
################################### 1
set origin 0,0
set xlabel '$E_\mathrm{b}/N_0$ [dB]'
set ylabel 'SER' offset 6,0
set key bottom left spacing 1 width 0 noautotitles nobox 
set label 1 "0.160 dB " at -0.75,0.0009 rotate left
set label 2 "Capacity bound" at -0.25,0.0009 rotate left
set title '(a)\quad\quad\quad\quad\quad\quad\quad\quad\quad$R=1/2$, $M=8$\quad\quad\quad\quad\quad\quad\quad\quad\quad\quad\quad'

#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'BER_R2Curve1.txt' using 1:2 with line lt 8 lc 7 ps 2,  'BER_R2Curve2.txt' using 1:2 with line lt 2 lc 7 ps 2, 'BER_R2Curve3.txt' using 1:2 with line lt 2 lc 7 ps 2,  'BER_R2Curve4.txt' using 1:2 with line lt 2 lc 7 ps 2,  'BER_R2Curve5.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R2Curve6.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R2Curve7.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R2Curve2.txt' using 1:2 lt 1 lc 7 pt 8 ps 2 ,  'BER_R2Curve3.txt' using 1:2 lt 1 lc 7 pt 4 ps 2 ,  'BER_R2Curve4.txt' using 1:2 lt 1 lc 7 pt 6 ps 2 ,  'BER_R2Curve5.txt' using 1:2 lt 1 lc 7 pt 8 ps 2 ,  'BER_R2Curve6.txt' using 1:2 lt 1 lc 7 pt 4 ps 2 ,  'BER_R2Curve7.txt' using 1:2 lt 1 lc 7 pt 6 ps 2 ,'dummy.txt' using 1:2 title 'Bit-by-bit' with line lt 2 lc 7 ps 2,'dummy.txt' using 1:2 title 'Frame-by-frame' with line lt 1 lc 7 ps 2,'dummy.txt' using 1:2 title '1200 ACS/bit/it' with points pt 6 ps 2,'dummy.txt' using 1:2 title '2400 ACS/bit/it' with points pt 4 ps 2,'dummy.txt' using 1:2 title '12000 ACS/bit/it' with points pt 8 ps 2 


unset xlabel
unset ylabel
unset label 1
unset label 2

#unset key


################################### 2
set origin 0.875,0
set xlabel '$E_\mathrm{b}/N_0$ [dB]'
set ylabel 'SER'  offset 6,0
set key bottom left spacing 1 width 0 noautotitles nobox 

set label 1 "-0.418 dB " at -1.25,0.0009 rotate left
set label 2 "Capacity bound" at -.75,0.0009 rotate left
set title '(b)\quad\quad\quad\quad\quad\quad\quad\quad\quad$R=1/3$, $M=4$\quad\quad\quad\quad\quad\quad\quad\quad\quad\quad\quad'

#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'BER_R3Curve1.txt' using 1:2 with line lt 8 lc 7 ps 2,  'BER_R3Curve2.txt' using 1:2 with line lt 2 lc 7 ps 2, 'BER_R3Curve3.txt' using 1:2 with line lt 2 lc 7 ps 2,  'BER_R3Curve4.txt' using 1:2 with line lt 2 lc 7 ps 2,  'BER_R3Curve5.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R3Curve6.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R3Curve7.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R3Curve2.txt' using 1:2 lt 1 lc 7 pt 6 ps 2 ,  'BER_R3Curve3.txt' using 1:2 lt 1 lc 7 pt 8 ps 2 ,  'BER_R3Curve4.txt' using 1:2 lt 1 lc 7 pt 4 ps 2 ,  'BER_R3Curve5.txt' using 1:2 lt 1 lc 7 pt 8 ps 2 ,  'BER_R3Curve6.txt' using 1:2 lt 1 lc 7 pt 4 ps 2 ,  'BER_R3Curve7.txt' using 1:2 lt 1 lc 7 pt 6 ps 2 ,              'dummy.txt' using 1:2 title 'Bit-by-bit' with line lt 2 lc 7 ps 2,'dummy.txt' using 1:2 title 'Frame-by-frame' with line lt 1 lc 7 ps 2,'dummy.txt' using 1:2 title '873 ACS/bit/it' with points pt 6 ps 2,'dummy.txt' using 1:2 title '1746 ACS/bit/it' with points pt 4 ps 2,'dummy.txt' using 1:2 title '8730 ACS/bit/it' with points pt 8 ps 2 


unset xlabel
unset ylabel
unset label 1
unset label 2

#unset key

################################### 3
set origin 0.875*2,0
set xlabel '$E_\mathrm{b}/N_0$ [dB]'
set ylabel 'SER'  offset 6,0
set key bottom left spacing 1 width 0 noautotitles nobox 
set label 1 "-0.739 dB " at -1.5,0.0009 rotate left
set label 2 "Capacity bound" at -1,0.0009 rotate left
set title '(c)\quad\quad\quad\quad\quad\quad\quad\quad\quad$R=1/4$, $M=2$\quad\quad\quad\quad\quad\quad\quad\quad\quad\quad\quad'


#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'BER_R4Curve1.txt' using 1:2 with line lt 8 lc 7 ps 2,  'BER_R4Curve2.txt' using 1:2 with line lt 2 lc 7 ps 2, 'BER_R4Curve3.txt' using 1:2 with line lt 2 lc 7 ps 2,  'BER_R4Curve4.txt' using 1:2 with line lt 2 lc 7 ps 2,  'BER_R4Curve5.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R4Curve6.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R4Curve7.txt' using 1:2 with line lt 1 lc 7 ps 2,  'BER_R4Curve2.txt' using 1:2 lt 1 lc 7 pt 4 ps 2 ,  'BER_R4Curve3.txt' using 1:2 lt 1 lc 7 pt 6 ps 2 ,  'BER_R4Curve4.txt' using 1:2 lt 1 lc 7 pt 8 ps 2 ,  'BER_R4Curve5.txt' using 1:2 lt 1 lc 7 pt 8 ps 2 ,  'BER_R4Curve6.txt' using 1:2 lt 1 lc 7 pt 4 ps 2 ,  'BER_R4Curve7.txt' using 1:2 lt 1 lc 7 pt 6 ps 2 ,'dummy.txt' using 1:2 title 'Bit-by-bit' with line lt 2 lc 7 ps 2,'dummy.txt' using 1:2 title 'Frame-by-frame' with line lt 1 lc 7 ps 2,'dummy.txt' using 1:2 title '552 ACS/bit/it' with points pt 6 ps 2,'dummy.txt' using 1:2 title '1104 ACS/bit/it' with points pt 4 ps 2,'dummy.txt' using 1:2 title '5520 ACS/bit/it' with points pt 8 ps 2 


unset xlabel
unset ylabel
unset label 1
unset label 2

#unset key

unset multiplot
