set term pslatex
set output 'EXIT.tex' 
set size square 1.2,1.2
#set log y
set xrange [0:1]
set yrange [0:1]
#set format y '$10^{%.0f}$'
#set key top left spacing 1.1 noautotitles nobox
#set ytics nomirror 0,0.2,1
#set xtics nomirror 0,0.2,1
#set tics out

set multiplot

################################### 1
set origin 0,0
set xlabel '$I(\tilde{\mathbf{z}}^\mathrm{a};\mathbf{z})$'
set ylabel '$I(\tilde{\mathbf{z}}^\mathrm{e};\mathbf{z})$' offset 1.5,0
#set label 1 '(a)' at screen 0.16, screen 1.2
#set arrow 2 from 0.12,0.88 to 0.43,0.7
#set label 3 "$r$" at 0.088,0.89
set key right spacing 1.5 width -4 noautotitles box 
set key at 3.61,0.7 right
set title '(a)\quad\quad\quad\quad\quad$R=1/2$, $M=8$, $E_\mathrm{b}/N_0=2$~dB\quad\quad\quad\quad\quad\quad\quad'
set arrow 4 from 0.4,0 to 0.4,0.56 nohead lt 2
set arrow 5 from 0.4,0.56 to 0.56,0.56 nohead lt 2
set arrow 6 from 0.56,0.56 to 0.56,0.7 nohead lt 2
set arrow 7 from 0.56,0.7 to 0.4,0.7 nohead lt 2


#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'R2_EXITCurve1.txt' using 1:2 with line lt 1 lc 7 ps 2, 'R2_EXITCurve1.txt' every 1 using 1:2  lt 1 lc 7 pt 11 ps 2, 'R2_EXITCurve2.txt' using 1:2 with line lt 1 lc 7 ps 2,  'R2_EXITCurve2.txt' every 1 using 1:2  lt 1 lc 7 pt 13 ps 2,      'R2_EXITCurve3.txt' using 1:2 with line lt 3 lc 7,        'R2_EXITCurve3.txt' every 3 using 1:2  lt 1 lc 7 pt 4 ps 2,      'R2_EXITCurve4.txt' using 1:2 with line lt 3 lc 7,  'R2_EXITCurve4.txt'every 3 using 1:2 lt 1 lc 7 pt 6 ps 2,  'R2_EXITCurve5.txt' using 1:2 with line lt 3 lc 7,      'R2_EXITCurve5.txt'every 3 using 1:2 lt 1 lc 7 pt 8 ps 2,     'dummy.txt' using 1:2 title 'Repetition EXIT function' with lp lt 3 pt 6 ps 2 , 'dummy.txt' using 1:2 title 'Frame-by-frame URC EXIT function' with lp lt 3 pt 8 ps 2, 'dummy.txt' using 1:2 title 'Bit-by-bit URC EXIT function' with lp lt 3 pt 4 ps 2, 'dummy.txt' using 1:2 title 'Frame-by-frame trajectory' with linespoints lt 1 lc 7 pt 11 ps 2, 'dummy.txt' using 1:2 title 'Bit-by-bit trajectory' with linespoints lt 1 lc 7 pt 13 ps 2, 'dummy.txt' using 1:2 title 'Bit-by-bit half-iteration trajectory' with linespoints lt 1 lc 7 pt 12 ps 2,      'R2_EXITCurveRob.txt'every 1 using 1:2 with lp lt 1 lc 7 pt 12 ps 2

unset arrow 4
unset arrow 5
unset arrow 6
unset arrow 7
unset xlabel
unset ylabel
#unset label 1
unset label 3
#unset key

################################### 2
set origin 0.875,0
set xlabel '$I(\tilde{\mathbf{z}}^\mathrm{a};\mathbf{z})$'
set ylabel '$I(\tilde{\mathbf{z}}^\mathrm{e};\mathbf{z})$'  offset 1.5,0
#set label 1 '(b)' at screen 1.025, screen 1.2
#set arrow 2 from 0.12,0.88 to 0.43,0.7
#set label 3 "$r$" at 0.088,0.89
set key bottom right spacing 1 width 0 noautotitles nobox 
set title '(b)\quad\quad\quad\quad\quad$R=1/3$, $M=4$, $E_\mathrm{b}/N_0=2$~dB\quad\quad\quad\quad\quad\quad\quad'
#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'R3_EXITCurve1.txt' using 1:2 with line lt 1 lc 7 ps 2, 'R3_EXITCurve1.txt' every 1 using 1:2  lt 1 lc 7 pt 11 ps 2, 'R3_EXITCurve2.txt' using 1:2 with line lt 1 lc 7 ps 2,  'R3_EXITCurve2.txt' every 1 using 1:2  lt 1 lc 7 pt 13 ps 2,      'R3_EXITCurve3.txt' using 1:2 with line lt 3 lc 7,        'R3_EXITCurve3.txt' every 3 using 1:2  lt 1 lc 7 pt 4 ps 2,      'R3_EXITCurve4.txt' using 1:2 with line lt 3 lc 7,  'R3_EXITCurve4.txt'every 3 using 1:2 lt 1 lc 7 pt 6 ps 2,  'R3_EXITCurve5.txt' using 1:2 with line lt 3 lc 7,      'R3_EXITCurve5.txt'every 3 using 1:2 lt 1 lc 7 pt 8 ps 2,      'R3_EXITCurveRob.txt'every 1 using 1:2 with lp lt 1 lc 7 pt 12 ps 2      

unset xlabel
unset ylabel
#unset label 1
unset label 3
#unset key


################################### 3
set origin 0,-1.2
set xlabel '$I(\tilde{\mathbf{z}}^\mathrm{a};\mathbf{z})$'
set ylabel '$I(\tilde{\mathbf{z}}^\mathrm{e};\mathbf{z})$'  offset 1.5,0
#set label 1 '(c)' at screen 0.16, screen 0
#set arrow 2 from 0.12,0.88 to 0.43,0.7
#set label 3 "$r$" at 0.088,0.89
set key top left spacing 1 width 0 noautotitles nobox 
set title '(c)\quad\quad\quad\quad\quad$R=1/4$, $M=2$, $E_\mathrm{b}/N_0=0$~dB\quad\quad\quad\quad\quad\quad\quad'

#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'R4_EXITCurve_0_1.txt' using 1:2 with line lt 1 lc 7 ps 2, 'R4_EXITCurve_0_1.txt' every 1 using 1:2  lt 1 lc 7 pt 11 ps 2, 'R4_EXITCurve_0_2.txt' using 1:2 with line lt 1 lc 7 ps 2,  'R4_EXITCurve_0_2.txt' every 1 using 1:2  lt 1 lc 7 pt 13 ps 2,      'R4_EXITCurve_0_3.txt' using 1:2 with line lt 3 lc 7,        'R4_EXITCurve_0_3.txt' every 3 using 1:2  lt 1 lc 7 pt 4 ps 2,      'R4_EXITCurve_0_4.txt' using 1:2 with line lt 3 lc 7,  'R4_EXITCurve_0_4.txt'every 3 using 1:2 lt 1 lc 7 pt 6 ps 2,  'R4_EXITCurve_0_5.txt' using 1:2 with line lt 3 lc 7,      'R4_EXITCurve_0_5.txt'every 3 using 1:2 lt 1 lc 7 pt 8 ps 2,      'R4_EXITCurveRob3.txt'every 1 using 1:2 with lp lt 1 lc 7 pt 12 ps 2      


unset xlabel
unset ylabel
#unset label 1
unset label 3
#unset key

################################### 4
set origin 0.875,-1.2
set xlabel '$I(\tilde{\mathbf{z}}^\mathrm{a};\mathbf{z})$'
set ylabel '$I(\tilde{\mathbf{z}}^\mathrm{e};\mathbf{z})$'  offset 1.5,0
#set label 1 '(d)' at screen 1.025, screen 0 
#set arrow 2 from 0.12,0.88 to 0.43,0.7
#set label 3 "$r$" at 0.088,0.89
set key top left spacing 1 width 0 noautotitles nobox 
set title '(d)\quad\quad\quad\quad\quad$R=1/4$, $M=2$, $E_\mathrm{b}/N_0=2$~dB\quad\quad\quad\quad\quad\quad\quad'
#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'R4_EXITCurve1.txt' using 1:2 with line lt 1 lc 7 ps 2, 'R4_EXITCurve1.txt' every 1 using 1:2  lt 1 lc 7 pt 11 ps 2, 'R4_EXITCurve2.txt' using 1:2 with line lt 1 lc 7 ps 2,  'R4_EXITCurve2.txt' every 1 using 1:2  lt 1 lc 7 pt 13 ps 2,      'R4_EXITCurve3.txt' using 1:2 with line lt 3 lc 7,        'R4_EXITCurve3.txt' every 3 using 1:2  lt 1 lc 7 pt 4 ps 2,      'R4_EXITCurve4.txt' using 1:2 with line lt 3 lc 7,  'R4_EXITCurve4.txt'every 3 using 1:2 lt 1 lc 7 pt 6 ps 2,  'R4_EXITCurve5.txt' using 1:2 with line lt 3 lc 7,      'R4_EXITCurve5.txt'every 3 using 1:2 lt 1 lc 7 pt 8 ps 2 ,      'R4_EXITCurveRob.txt'every 1 using 1:2 with lp lt 1 lc 7 pt 12 ps 2     

unset xlabel
unset ylabel
#unset label 1
unset label 3
#unset key



################################### 5
set origin 0.875*2,-1.2
set xlabel '$I(\tilde{\mathbf{z}}^\mathrm{a};\mathbf{z})$'
set ylabel '$I(\tilde{\mathbf{z}}^\mathrm{e};\mathbf{z})$'  offset 1.5,0
#set label 1 '(e)' at screen 1.905, screen 0
#set arrow 2 from 0.12,0.88 to 0.43,0.7
#set label 3 "$r$" at 0.088,0.89
#set key bottom right spacing 1 width 0 noautotitles nobox 
#set key at 1,0.35
set title '(e)\quad\quad\quad\quad\quad$R=1/4$, $M=2$, $E_\mathrm{b}/N_0=4$~dB\quad\quad\quad\quad\quad\quad\quad'
#samplen 2 spacing .5 font ",8"
#IAs;r=2;r=4;r=6;EbN0=-1.9;0.1;2.1;
plot 'R4_EXITCurve_4_1.txt' using 1:2 with line lt 1 lc 7 ps 2, 'R4_EXITCurve_4_1.txt' every 1 using 1:2  lt 1 lc 7 pt 11 ps 2, 'R4_EXITCurve_4_2.txt' using 1:2 with line lt 1 lc 7 ps 2,  'R4_EXITCurve_4_2.txt' every 1 using 1:2  lt 1 lc 7 pt 13 ps 2,      'R4_EXITCurve_4_3.txt' using 1:2 with line lt 3 lc 7,        'R4_EXITCurve_4_3.txt' every 3 using 1:2  lt 1 lc 7 pt 4 ps 2,      'R4_EXITCurve_4_4.txt' using 1:2 with line lt 3 lc 7,  'R4_EXITCurve_4_4.txt'every 3 using 1:2 lt 1 lc 7 pt 6 ps 2,  'R4_EXITCurve_4_5.txt' using 1:2 with line lt 3 lc 7,      'R4_EXITCurve_4_5.txt'every 3 using 1:2 lt 1 lc 7 pt 8 ps 2,      'R4_EXITCurveRob2.txt'every 1 using 1:2 with lp lt 1 lc 7 pt 12 ps 2      


unset xlabel
unset ylabel
#unset label 1
unset label 3
#unset key


unset multiplot
