% Generate the WiMAX interleaver, as specified in IEEE Std 802.16-2012
% Copyright (C) 2013  Robert G. Maunder

% This program is free software: you can redistribute it and/or modify it 
% under the terms of the GNU General Public License as published by the
% Free Software Foundation, either version 3 of the License, or (at your 
% option) any later version.

% This program is distributed in the hope that it will be useful, but 
% WITHOUT ANY WARRANTY; without even the implied warranty of 
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
% Public License for more details.

% The GNU General Public License can be seen at http://www.gnu.org/licenses/.

% N is a scalar that specifies the number of algorithmic blocks in the turbo code
% interleaver is a 1x2N vector of unique integers in the range 1 to 2N

% Interleaving may be achieved using the following code
%AB = reshape([A;B],1,numel(A)+numel(B));
%interleaved_AB = AB(interleaver);
%interleaved_A = interleaved_AB(1:2:end);
%interleaved_B = interleaved_AB(2:2:end);

%Deinterleaving may be achieved using the following code
%interleaved_AB = reshape([interleaved_A;interleaved_B],1,numel(interleaved_A)+numel(interleaved_B));
%AB(interleaver) = interleaved_AB;
%A = AB(1:2:end);
%B = AB(2:2:end);

function interleaver = get_WiMAX_interleaver(N)

    
parameters=[    24, 5, 0, 0, 0;
                36, 11, 18, 0, 18;
                48, 13, 24, 0, 24;
                72, 11, 6, 0, 6;
                96, 7, 48, 24, 72;
                108, 11, 54, 56, 2;
                120, 13, 60, 0, 60;
                144, 17, 74, 72, 2;
                180, 11, 90, 0, 90;
                192, 11, 96, 48, 144;
                216, 13, 108, 0, 108;
                240, 13, 120, 60, 180;
                480, 53, 62,  12, 2;
                960, 43, 64, 300, 824;
                1440, 43, 720, 360, 540;
                1920, 31, 8, 24, 16;
                2400, 53, 66, 24, 2];

index = find(parameters(:,1) == N);

if isempty(index)
    error('N value not supported!');
end

interleaver = zeros(2,N);

for j = 0:N-1
    switch mod(j,4)
        case 0
            P_j = mod(parameters(index,2)*j+1,N);
        case 1
            P_j = mod(parameters(index,2)*j+1+N/2+parameters(index,3),N);
        case 2
            P_j = mod(parameters(index,2)*j+1+parameters(index,4),N);            
        case 3
            P_j = mod(parameters(index,2)*j+1+N/2+parameters(index,5),N);            
    end
    
    if mod(j,2)
        interleaver(1,j+1) = 2*P_j+2;
        interleaver(2,j+1) = 2*P_j+1;       
    else
        interleaver(1,j+1) = 2*P_j+1;
        interleaver(2,j+1) = 2*P_j+2;       
    end
    
end

interleaver = reshape(interleaver, 1, 2*N);

    