function crosscor_Callback(hObject, eventdata)
% hObject    handle to crosscor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=guidata(hObject);
var_mpiv.file_1         = handles.val_filename_1;
var_mpiv.file_2         = handles.val_filename_2;
val_strel = handles.val_strel;
progressBar(hObject, eventdata,0);
global TP
global im

var.mpiv_filename_1 = imread(handles.TP_name);
background1 = imopen(var.mpiv_filename_1,strel('square',val_strel));
TP = imadjust(var.mpiv_filename_1 - background1);
axes(handles.axes1);
imshow(TP);

if ischar(handles.filename_im)

    TP = imread(handles.TP_name);
    im = imread(handles.imfile);

    c = normxcorr2(TP, im);
%centre of the correlation matrix
    centre=round(size(c)./2);

%find the coordinates for the shift of the correlation matrix
    [y,x]=find(c==max(c(:)));

%find the relative offset between the pictures
    xoffset = x-centre(2)
    yoffset = y-centre(1)

%prepare empty space for displaying original image
    image=uint16(zeros(2*size(TP,1)+size(im,1),2*size(TP,2)+size(im,2)));

    xbegin_im = size(TP,2);
    xend_im = xbegin_im+size(im,2)-1;
    ybegin_im = size(TP,1);
    yend_im = ybegin_im+size(im,1)-1;

%prepare template to overlap the original image
    im_TP=uint16(zeros(2*size(TP,1)+size(im,1),2*size(TP,2)+size(im,2)));

    xbegin_TP = x;
    xend_TP = x+size(TP,2)-1;
    ybegin_TP = y;
    yend_TP = y+size(TP,1)-1;

    image(ybegin_im:yend_im,xbegin_im:xend_im) = im;
    im_TP(ybegin_TP:yend_TP,xbegin_TP:xend_TP) = TP;

%figure(1)
%imshowpair(image,im_TP,'falsecolor');
              
    set(handles.savemydata,'Enable','on')
end

if not(ischar(handles.filename_im))
    var.mpiv_filename_1 = imread(handles.TP_name);
background1 = imopen(var.mpiv_filename_1,strel('square',val_strel));
TP = imadjust(var.mpiv_filename_1 - background1);
    progressBar(hObject, eventdata, 0);
    pause(0.01);
    
        for i=1:size((handles.filename_im),2)
         %      disp(['User selected ', char(fullfile(pathname, filename(i)))])

        var.mpiv_filename_2 = imread(char(handles.imfile2(i)));
        background2 = imopen(var.mpiv_filename_2,strel('square',val_strel));
        im2 = imadjust(var.mpiv_filename_2 - background2);
        disp('Processing file:')
        disp(char(handles.imfile2(i)))
        axes(handles.axes2);
        %imshow(char(handles.imfile2(i)));
        imshow(im2);
                pause(0.01);
                c = normxcorr2(TP, im2);
                counter=i/size((handles.filename_im),2);
                progressBar(hObject, eventdata, counter);
                pause(0.01);

                centre=round(size(c)./2);

                %find the coordinates for the shift of the correlation matrix
                [y,x]=find(c==max(c(:)));

                handles.xoffset(i) = x-centre(2);
                handles.yoffset(i) = y-centre(1);

        %prepare space for displaying original image
        image=uint16(zeros(2*size(TP,1)+size(im,1),2*size(TP,2)+size(im,2)));

        xbegin_im = size(TP,2);
        xend_im = xbegin_im+size(im,2)-1;
        ybegin_im = size(TP,1);
        yend_im = ybegin_im+size(im,1)-1;

        %prepare template to overlap the original image
        im_TP=uint16(zeros(2*size(TP,1)+size(im,1),2*size(TP,2)+size(im,2)));

        xbegin_TP = x;
        xend_TP = x+size(TP,2)-1;
        ybegin_TP = y;
        yend_TP = y+size(TP,1)-1;

        image(ybegin_im:yend_im,xbegin_im:xend_im) = im;
        im_TP(ybegin_TP:yend_TP,xbegin_TP:xend_TP) = TP;

                %figure(1)
                %pause(1);
                %imshowpair(image,im_TP,'falsecolor');
                %pause(1);

        end

end

set(handles.savemydata,'Enable','on')
      figure(2)
      plot(handles.yoffset,'r *');
      title('y-axis offset between the template','fontsize',14)
      xlabel('image#','fontsize',14);
      ylabel('[pixels]','fontsize',14);
      grid on
      
      %get the difference shift between two consecutive images for yoffset
for i=1:length(handles.yoffset)-1
    handles.yoffsetdiff(i)=handles.yoffset(i+1)-handles.yoffset(i);
end
      figure(3)
      plot(handles.yoffsetdiff,'r o');
      title('y-axis offset between two cons. images [pix]','fontsize',14)
      xlabel('image#','fontsize',14);
      ylabel('[pixels]','fontsize',14);
      grid on
      

guidata(hObject, handles);

end

