 function varargout = ctcgui2(varargin)
% CTCGUI2 MATLAB code for ctcgui2.fig
%      CTCGUI2, by itself, creates a new CTCGUI2 or raises the existing
%      singleton*.
%
%      H = CTCGUI2 returns the handle to a new CTCGUI2 or the handle to
%      the existing singleton*.
%
%      CTCGUI2('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CTCGUI2.M with the given input arguments.
%
%      CTCGUI2('Property','Value',...) creates a new CTCGUI2 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before ctcgui2_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to ctcgui2_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help ctcgui2

% Last Modified by GUIDE v2.5 27-Aug-2014 21:38:36

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @ctcgui2_OpeningFcn, ...
                   'gui_OutputFcn',  @ctcgui2_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before ctcgui2 is made visible.
function ctcgui2_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to ctcgui2 (see VARARGIN)

% Choose default command line output for ctcgui2

%set(handles.loadmultiple,'Enable','off')
set(handles.savemydata,'Enable','off')
set(handles.crosscor,'Enable','off')

set(handles.crosscor,'Callback',{@crosscor_Callback});
set(handles.loadmultiple,'Callback',@loadmultiple_Callback);
set(handles.xCorrPairs,'Callback',@xCorrPairs_Callback);
set(handles.startMPIV,'Callback',@startMPIV_Callback);
set(handles.mpivToTemp,'Callback',@mpivToTemp_Callback);
set(handles.removeBackround,'Callback',@removeBackround_Callback);


handles.val_filename_1    = 'image1.bmp';
handles.val_filename_2    = 'image2.bmp';
handles.val_pivType     = 'COR';
handles.val_winSize_x   = 64;
handles.val_winSize_y   = 64;
handles.val_maxDisp_x   = 20;
handles.val_maxDisp_y   = 20;
handles.val_overlap     = 0.5;
handles.val_dt          = 1;
handles.val_iter        = 1;
handles.val_strel       = 32;

handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes ctcgui2 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = ctcgui2_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in loadsingle.
function loadsingle_Callback(hObject, eventdata, handles)
% hObject    handle to loadsingle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global TP;
filterspec={'*.tif';'*.gif';'*.png';'*.bmp'};
 [filename, pathname, filterindex] = uigetfile(filterspec, 'Pick a single image file');
  if isequal(filename,0) || isequal(pathname,0)
      msgbox(sprintf('Error'),'Error', 'Error'); 
      disp('User pressed cancel')
    else
       disp(['User selected ', fullfile(pathname, filename)])
       TP_name = fullfile(pathname, filename);
       handles.TP_name = TP_name;
       TP = imread(handles.TP_name);
       axes(handles.axes1);
       imshow(imadjust(TP));
       TP = im2double(TP);
  end
  set(handles.loadmultiple,'Enable','on');


guidata(hObject, handles);

% --- Executes on button press in loadmultiple.

  
% --- Executes on button press in savemydata.
function savemydata_Callback(hObject, eventdata, handles)
% hObject    handle to savemydata (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

format long;
yoff = double(handles.yoffset);
xoff = double(handles.xoffset);
yoffdiff = double(handles.yoffsetdiff);
freq = double(handles.freq);
spectrum = double(handles.spectrum);
angle = rad2deg(double(handles.angle));

save offsets-data.txt xoff yoff yoffdiff freq spectrum angle -ascii -tabs

guidata(hObject, handles);


% --- Executes on selection change in pivType.
function pivType_Callback(hObject, eventdata, handles)
% hObject    handle to pivType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns pivType contents as cell array
%        contents{get(hObject,'Value')} returns selected item from pivType
val = get(hObject,'Value');
switch val
    case 1
        handles.val_pivType = 'COR';
    case 2
        handles.val_pivType = 'MQD';
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function pivType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pivType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function maxDisp_x_Callback(hObject, eventdata, handles)
% hObject    handle to maxDisp_x (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maxDisp_x as text
%        str2double(get(hObject,'String')) returns contents of maxDisp_x as a double
handles.val_maxDisp_x = str2double(get(hObject,'String'));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function maxDisp_x_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maxDisp_x (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function maxDisp_y_Callback(hObject, eventdata, handles)
% hObject    handle to maxDisp_y (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maxDisp_y as text
%        str2double(get(hObject,'String')) returns contents of maxDisp_y as a double
handles.val_maxDisp_y = str2double(get(hObject,'String'));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function maxDisp_y_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maxDisp_y (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function winSize_x_Callback(hObject, eventdata, handles)
% hObject    handle to winSize_x (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of winSize_x as text
%        str2double(get(hObject,'String')) returns contents of winSize_x as a double
handles.val_winSize_x = str2double(get(hObject,'String'));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function winSize_x_CreateFcn(hObject, eventdata, handles)
% hObject    handle to winSize_x (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function winSize_y_Callback(hObject, eventdata, handles)
% hObject    handle to winSize_y (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of winSize_y as text
%        str2double(get(hObject,'String')) returns contents of winSize_y as a double
handles.val_winSize_y = str2double(get(hObject,'String'));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function winSize_y_CreateFcn(hObject, eventdata, handles)
% hObject    handle to winSize_y (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in numIter.
function numIter_Callback(hObject, eventdata, handles)
% hObject    handle to numIter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns numIter contents as cell array
%        contents{get(hObject,'Value')} returns selected item from numIter

val = get(hObject,'Value');
switch val
    case 1
        handles.val_iter = 1;
    case 2
        handles.val_iter = 0;
    case 3
        handles.val_iter = 1;
    case 4
        handles.val_iter = 2;
    case 5
        handles.val_iter = 3;
    case 6
        handles.val_iter = 4;
    case 7
        handles.val_iter = 5;
end
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function numIter_CreateFcn(hObject, eventdata, handles)
% hObject    handle to numIter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function overlap_Callback(hObject, eventdata, handles)
% hObject    handle to overlap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of overlap as text
%        str2double(get(hObject,'String')) returns contents of overlap as a double
handles.val_ovelrap = str2double(get(hObject,'String'));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function overlap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to overlap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function dt_Callback(hObject, eventdata, handles)
% hObject    handle to dt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of dt as text
%        str2double(get(hObject,'String')) returns contents of dt as a double
handles.val_dt = str2double(get(hObject,'String'));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function dt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to dt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function strel_Callback(hObject, eventdata, handles)
% hObject    handle to strel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of strel as text
%        str2double(get(hObject,'String')) returns contents of strel as a double
handles.val_strel = str2double(get(hObject,'String'));
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function strel_CreateFcn(hObject, eventdata, handles)
% hObject    handle to strel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

