function extract_data_gui(src, eventdata)

clear all

eventdata = struct('figure',0,'axe',0,'data',0,'figplot1',0,'figplot2',0,'counter',0);

eventdata.figplot1 = figure;
        title('Y-displacement avg median abs deviation at different driving voltages','Color','r');
        xlabel('sequence number');
        ylabel('avg displacement in pixels');
eventdata.figplot2 = figure;

        title('Last sequence Y-displacement avg median abs deviation at different driving voltages','Color','r');
        xlabel('voltage [V]');
        ylabel('avg displacement in pixels');
        
eventdata.voltages = [3 6 9 12 18];
%% Here we construct the GUI

   %  Create and then hide the GUI as it is being constructed.
	set(0,'Units','pixels');
	scr  = get(0,'ScreenSize');
	src = figure('Visible','off','Position',[360,500,550,685]);
    %boxp = figure('Visible','off','Position',[360,500,550,385]);
    %figplot2 = figure('Visible','off','Position',[360,500,550,385]);
    
%    boxp = figure('Visible','off','Position',[360,500,550,385]);
%    row = figure('Visible','off','Position',[360,500,550,385]);
%    col = figure('Visible','off','Position',[360,500,550,385]);
%    main = figure('Visible','off','Position',[360,500,550,385]);
    
	set(src,'Renderer','OpenGL');
    position = get(src,'Position');
    outerpos = get(src,'OuterPosition');
    borders = outerpos - position;
    edge = -borders(1)/2;
    mainpos = [0, 0, scr(3)/3, scr(4)];
    set(src,'OuterPosition',mainpos);

   %  Construct the components of the main window.
        set(0,'CurrentFigure',src);
        hread = uicontrol('Style','pushbutton','String','Read Data',...
          'Position',[450,220,70,25],...
          'Callback',{@read_Callback});
        hadddata = uicontrol('Style','pushbutton','String','Add Data',...
          'Position',[450,180,70,25],...
          'Callback',{@data_Callback});
        hplot = uicontrol('Style','pushbutton',...
          'String','Plot Data',...
          'Position',[450,135,70,25],...
          'Callback',{@plot_Callback}); 

        ha2 = axes('Units','Pixels','Position',[50,360,380,300]);
        ha = axes('Units','Pixels','Position',[50,30,380,300]);

    align([hread,hadddata,hplot],'Center','None');
      
   % Initialize the GUI.
   % Change units to normalized so components resize 
   % automatically.
   set([src,ha,ha2,hread hadddata,hplot], 'Units','normalized');
   set(src,'Name','CTC MPIV data viewer')
   % Move the GUI to the center of the screen.
    movegui(src,'center')
   % Make the GUI visible.
    set(src,'Visible','on');
    
    guidata(src, eventdata);
   

   
    function read_Callback(src, eventdata) 

        eventdata=guidata(src);
    filterspec={'*.fig'};
     [filename, pathname, filterindex] = uigetfile(filterspec, 'Pick a figure file');
      if isequal(filename,0) || isequal(pathname,0)
            msgbox(sprintf('Error'),'Error', 'Error'); 
            disp('User pressed cancel')
      else

            disp(['User selected', fullfile(pathname, filename)])
            file_name = fullfile(pathname, filename);

            open(file_name);
            eventdata
            eventdata.figure = gcf;
            eventdata.axe = get(eventdata.figure, 'Children');  %axes handles
            eventdata.data = get(eventdata.axe, 'Children'); % data from axes handles

            guidata(src,eventdata);
      end
    end
  
    function data_Callback(src, eventdata)

        eventdata=guidata(src);

        eventdata.ydata = get(eventdata.data,'ydata')
        eventdata.counter = eventdata.counter + 1;
        
        guidata(src,eventdata);
        
    end
    
    function plot_Callback(src, eventdata)
        color = {'r' 'g' 'b' 'c' 'm'};
        eventdata=guidata(src);
        
        eventdata.y(eventdata.counter) = eventdata.ydata(numel(eventdata.ydata))
        figure(eventdata.figplot1)
        hold on
        plot(eventdata.ydata,char(color(eventdata.counter)))
        hold off
        legend('3V','6V','9V','12V','18V');
        figure(eventdata.figplot2)
        
        plot(eventdata.y,'ro')
        guidata(src,eventdata);
    end
end

