function progressBar(hObject, eventdata, progress)

handles=guidata(hObject);

    %# a figure and a plot area
    handles.hFig = get(0,'CurrentFigure');

    handles.hAx = axes('Parent',handles.hFig, 'XLim',[0 1], 'YLim',[0 1], ...
        'XTick',[], 'YTick',[], 'Box','on', 'Layer','top', ...
        'Units','normalized', 'Position',[0 0.9 1 0.1]);
   
    handles.hPatch = patch([0 0 progress progress], [0 1 1 0], 'r', 'Parent',handles.hAx, ...
        'FaceColor','r', 'EdgeColor','none');
   
    handles.hText = text(0.5, 0.5, sprintf('%.0f%%',progress*100), ...
        'Parent',handles.hAx, 'Color','w', 'BackgroundColor',[.9 .5 .5], ...
        'HorizontalAlign','center', 'VerticalAlign','middle', ...
        'FontSize',16, 'FontWeight','bold');
  

    %# update progress bar
        set(handles.hPatch, 'XData',[0 0 progress progress])
        set(handles.hText, 'String',sprintf('%.0f%%',progress*100))

guidata(hObject, handles);

end