function startMPIV_Callback(hObject, eventdata)

handles=guidata(hObject);
progressBar(hObject, eventdata,0);

var_mpiv.file_1         = handles.val_filename_1;
var_mpiv.file_2         = handles.val_filename_2;
var_mpiv.pivmethod      = handles.val_pivType;
var_mpiv.windowsize_x   = handles.val_winSize_x;
var_mpiv.windowsize_y   = handles.val_winSize_y;
var_mpiv.maxdisplace_x  = handles.val_maxDisp_x;
var_mpiv.maxdisplace_y  = handles.val_maxDisp_y;
var_mpiv.overlap        = handles.val_overlap;
var_mpiv.deltat         = handles.val_dt;
var_mpiv.iteration      = handles.val_iter;
val_strel               = handles.val_strel;


if isequal(handles.filename_im,0) || isequal(handles.pathname_im,0) || isequal(size(handles.filename_im ,2),1)
    msgbox(sprintf('Insufficient number of images to process \n Load two or more images'),'Error', 'Error'); 
    disp('Insufficient number of images to process');
else

    progressBar(hObject, eventdata, 0);

    for i=1:size(handles.filename_im, 2) - 1
        
        var.mpiv_filename_1 = imread(char(handles.imfile2(i)));
        var.mpiv_filename_2 = imread(char(handles.imfile2(i+1)));

        % bacground subtraction using morphological operations (errosion followed by dilation)
        
        background1 = imopen(var.mpiv_filename_1,strel('square',val_strel));
        background2 = imopen(var.mpiv_filename_2,strel('square',val_strel));
        
        im1 = imadjust(var.mpiv_filename_1 - background1);
        im2 = imadjust(var.mpiv_filename_2 - background2);
        disp('Processing file:')
        disp(char(handles.imfile2(i+1)))
        axes(handles.axes1);
        %imshow(char(handles.imfile2(i)));
        imshow(im1);
        axes(handles.axes2);
        imshow(im2);
        pause(0.1);
        figure(3);
        [xi, yi, iu, iv] = mpiv(im1, im2, var_mpiv.windowsize_x, ...
                            var_mpiv.windowsize_y, var_mpiv.overlap, ...
                            var_mpiv.overlap, var_mpiv.maxdisplace_x, ...
                            var_mpiv.maxdisplace_y, var_mpiv.deltat, ...
                            var_mpiv.pivmethod, var_mpiv.iteration, 1 );
                        
        [iu_ft, iv_ft, iu_ip, iv_ip] = mpiv_filter(iu, iv, 2, 2.0, 3, 1 );
                        
        axes(handles.axes2);
        counter=i/(size((handles.filename_im),2) - 1);
        guidata(hObject, handles);
        progressBar(hObject, eventdata, counter);
       
        figure(10)
        
        iuData(:,:,i) = iu;
        ivData(:,:,i) = iv;
        iu_ipData(:,:,i) = iu_ip;
        iv_ipData(:,:,i) = iv_ip;
    end
%    xi = xgrid;
%    yi = ygrid;
    save('mpiv_vecdata.mat','xi','yi','iuData','ivData','iu_ipData','iv_ipData');
end

guidata(hObject, handles);
end